/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.ApplicableAssetTypesCopier;
import software.amazon.awssdk.services.datazone.model.AuthorizedPrincipalIdentifiersCopier;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.SubscriptionTargetForm;
import software.amazon.awssdk.services.datazone.model.SubscriptionTargetFormsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSubscriptionTargetRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateSubscriptionTargetRequest> {
    private static final SdkField<List<String>> APPLICABLE_ASSET_TYPES_FIELD = SdkField.builder(MarshallingType.LIST).memberName("applicableAssetTypes").getter(CreateSubscriptionTargetRequest.getter(CreateSubscriptionTargetRequest::applicableAssetTypes)).setter(CreateSubscriptionTargetRequest.setter(Builder::applicableAssetTypes)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicableAssetTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<List<String>> AUTHORIZED_PRINCIPALS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("authorizedPrincipals").getter(CreateSubscriptionTargetRequest.getter(CreateSubscriptionTargetRequest::authorizedPrincipals)).setter(CreateSubscriptionTargetRequest.setter(Builder::authorizedPrincipals)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizedPrincipals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("clientToken").getter(CreateSubscriptionTargetRequest.getter(CreateSubscriptionTargetRequest::clientToken)).setter(CreateSubscriptionTargetRequest.setter(Builder::clientToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainIdentifier").getter(CreateSubscriptionTargetRequest.getter(CreateSubscriptionTargetRequest::domainIdentifier)).setter(CreateSubscriptionTargetRequest.setter(Builder::domainIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();
    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentIdentifier").getter(CreateSubscriptionTargetRequest.getter(CreateSubscriptionTargetRequest::environmentIdentifier)).setter(CreateSubscriptionTargetRequest.setter(Builder::environmentIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentIdentifier").build()).build();
    private static final SdkField<String> MANAGE_ACCESS_ROLE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("manageAccessRole").getter(CreateSubscriptionTargetRequest.getter(CreateSubscriptionTargetRequest::manageAccessRole)).setter(CreateSubscriptionTargetRequest.setter(Builder::manageAccessRole)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageAccessRole").build()).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("name").getter(CreateSubscriptionTargetRequest.getter(CreateSubscriptionTargetRequest::name)).setter(CreateSubscriptionTargetRequest.setter(Builder::name)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("provider").getter(CreateSubscriptionTargetRequest.getter(CreateSubscriptionTargetRequest::provider)).setter(CreateSubscriptionTargetRequest.setter(Builder::provider)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()).build();
    private static final SdkField<List<SubscriptionTargetForm>> SUBSCRIPTION_TARGET_CONFIG_FIELD = SdkField.builder(MarshallingType.LIST).memberName("subscriptionTargetConfig").getter(CreateSubscriptionTargetRequest.getter(CreateSubscriptionTargetRequest::subscriptionTargetConfig)).setter(CreateSubscriptionTargetRequest.setter(Builder::subscriptionTargetConfig)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionTargetConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(SubscriptionTargetForm::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("type").getter(CreateSubscriptionTargetRequest.getter(CreateSubscriptionTargetRequest::type)).setter(CreateSubscriptionTargetRequest.setter(Builder::type)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICABLE_ASSET_TYPES_FIELD, AUTHORIZED_PRINCIPALS_FIELD, CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, MANAGE_ACCESS_ROLE_FIELD, NAME_FIELD, PROVIDER_FIELD, SUBSCRIPTION_TARGET_CONFIG_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSubscriptionTargetRequest.memberNameToFieldInitializer();
    private final List<String> applicableAssetTypes;
    private final List<String> authorizedPrincipals;
    private final String clientToken;
    private final String domainIdentifier;
    private final String environmentIdentifier;
    private final String manageAccessRole;
    private final String name;
    private final String provider;
    private final List<SubscriptionTargetForm> subscriptionTargetConfig;
    private final String type;

    private CreateSubscriptionTargetRequest(BuilderImpl builder) {
        super(builder);
        this.applicableAssetTypes = builder.applicableAssetTypes;
        this.authorizedPrincipals = builder.authorizedPrincipals;
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.manageAccessRole = builder.manageAccessRole;
        this.name = builder.name;
        this.provider = builder.provider;
        this.subscriptionTargetConfig = builder.subscriptionTargetConfig;
        this.type = builder.type;
    }

    public final boolean hasApplicableAssetTypes() {
        return this.applicableAssetTypes != null && !(this.applicableAssetTypes instanceof SdkAutoConstructList);
    }

    public final List<String> applicableAssetTypes() {
        return this.applicableAssetTypes;
    }

    public final boolean hasAuthorizedPrincipals() {
        return this.authorizedPrincipals != null && !(this.authorizedPrincipals instanceof SdkAutoConstructList);
    }

    public final List<String> authorizedPrincipals() {
        return this.authorizedPrincipals;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String environmentIdentifier() {
        return this.environmentIdentifier;
    }

    public final String manageAccessRole() {
        return this.manageAccessRole;
    }

    public final String name() {
        return this.name;
    }

    public final String provider() {
        return this.provider;
    }

    public final boolean hasSubscriptionTargetConfig() {
        return this.subscriptionTargetConfig != null && !(this.subscriptionTargetConfig instanceof SdkAutoConstructList);
    }

    public final List<SubscriptionTargetForm> subscriptionTargetConfig() {
        return this.subscriptionTargetConfig;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicableAssetTypes() ? this.applicableAssetTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedPrincipals() ? this.authorizedPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.manageAccessRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscriptionTargetConfig() ? this.subscriptionTargetConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubscriptionTargetRequest)) {
            return false;
        }
        CreateSubscriptionTargetRequest other = (CreateSubscriptionTargetRequest)obj;
        return this.hasApplicableAssetTypes() == other.hasApplicableAssetTypes() && Objects.equals(this.applicableAssetTypes(), other.applicableAssetTypes()) && this.hasAuthorizedPrincipals() == other.hasAuthorizedPrincipals() && Objects.equals(this.authorizedPrincipals(), other.authorizedPrincipals()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(this.manageAccessRole(), other.manageAccessRole()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.provider(), other.provider()) && this.hasSubscriptionTargetConfig() == other.hasSubscriptionTargetConfig() && Objects.equals(this.subscriptionTargetConfig(), other.subscriptionTargetConfig()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder("CreateSubscriptionTargetRequest").add("ApplicableAssetTypes", this.hasApplicableAssetTypes() ? this.applicableAssetTypes() : null).add("AuthorizedPrincipals", this.hasAuthorizedPrincipals() ? this.authorizedPrincipals() : null).add("ClientToken", this.clientToken()).add("DomainIdentifier", this.domainIdentifier()).add("EnvironmentIdentifier", this.environmentIdentifier()).add("ManageAccessRole", this.manageAccessRole()).add("Name", this.name() == null ? null : "*** Sensitive Data Redacted ***").add("Provider", this.provider()).add("SubscriptionTargetConfig", this.hasSubscriptionTargetConfig() ? this.subscriptionTargetConfig() : null).add("Type", this.type()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicableAssetTypes": {
                return Optional.ofNullable(clazz.cast(this.applicableAssetTypes()));
            }
            case "authorizedPrincipals": {
                return Optional.ofNullable(clazz.cast(this.authorizedPrincipals()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "environmentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentIdentifier()));
            }
            case "manageAccessRole": {
                return Optional.ofNullable(clazz.cast(this.manageAccessRole()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "subscriptionTargetConfig": {
                return Optional.ofNullable(clazz.cast(this.subscriptionTargetConfig()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("applicableAssetTypes", APPLICABLE_ASSET_TYPES_FIELD);
        map.put("authorizedPrincipals", AUTHORIZED_PRINCIPALS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("environmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
        map.put("manageAccessRole", MANAGE_ACCESS_ROLE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("provider", PROVIDER_FIELD);
        map.put("subscriptionTargetConfig", SUBSCRIPTION_TARGET_CONFIG_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSubscriptionTargetRequest, T> g) {
        return obj -> g.apply((CreateSubscriptionTargetRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private List<String> applicableAssetTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> authorizedPrincipals = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private String domainIdentifier;
        private String environmentIdentifier;
        private String manageAccessRole;
        private String name;
        private String provider;
        private List<SubscriptionTargetForm> subscriptionTargetConfig = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubscriptionTargetRequest model) {
            super(model);
            this.applicableAssetTypes(model.applicableAssetTypes);
            this.authorizedPrincipals(model.authorizedPrincipals);
            this.clientToken(model.clientToken);
            this.domainIdentifier(model.domainIdentifier);
            this.environmentIdentifier(model.environmentIdentifier);
            this.manageAccessRole(model.manageAccessRole);
            this.name(model.name);
            this.provider(model.provider);
            this.subscriptionTargetConfig(model.subscriptionTargetConfig);
            this.type(model.type);
        }

        public final Collection<String> getApplicableAssetTypes() {
            if (this.applicableAssetTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicableAssetTypes;
        }

        public final void setApplicableAssetTypes(Collection<String> applicableAssetTypes) {
            this.applicableAssetTypes = ApplicableAssetTypesCopier.copy(applicableAssetTypes);
        }

        @Override
        public final Builder applicableAssetTypes(Collection<String> applicableAssetTypes) {
            this.applicableAssetTypes = ApplicableAssetTypesCopier.copy(applicableAssetTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicableAssetTypes(String ... applicableAssetTypes) {
            this.applicableAssetTypes(Arrays.asList(applicableAssetTypes));
            return this;
        }

        public final Collection<String> getAuthorizedPrincipals() {
            if (this.authorizedPrincipals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.authorizedPrincipals;
        }

        public final void setAuthorizedPrincipals(Collection<String> authorizedPrincipals) {
            this.authorizedPrincipals = AuthorizedPrincipalIdentifiersCopier.copy(authorizedPrincipals);
        }

        @Override
        public final Builder authorizedPrincipals(Collection<String> authorizedPrincipals) {
            this.authorizedPrincipals = AuthorizedPrincipalIdentifiersCopier.copy(authorizedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedPrincipals(String ... authorizedPrincipals) {
            this.authorizedPrincipals(Arrays.asList(authorizedPrincipals));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getManageAccessRole() {
            return this.manageAccessRole;
        }

        public final void setManageAccessRole(String manageAccessRole) {
            this.manageAccessRole = manageAccessRole;
        }

        @Override
        public final Builder manageAccessRole(String manageAccessRole) {
            this.manageAccessRole = manageAccessRole;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final List<SubscriptionTargetForm.Builder> getSubscriptionTargetConfig() {
            List<SubscriptionTargetForm.Builder> result = SubscriptionTargetFormsCopier.copyToBuilder(this.subscriptionTargetConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscriptionTargetConfig(Collection<SubscriptionTargetForm.BuilderImpl> subscriptionTargetConfig) {
            this.subscriptionTargetConfig = SubscriptionTargetFormsCopier.copyFromBuilder(subscriptionTargetConfig);
        }

        @Override
        public final Builder subscriptionTargetConfig(Collection<SubscriptionTargetForm> subscriptionTargetConfig) {
            this.subscriptionTargetConfig = SubscriptionTargetFormsCopier.copy(subscriptionTargetConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionTargetConfig(SubscriptionTargetForm ... subscriptionTargetConfig) {
            this.subscriptionTargetConfig(Arrays.asList(subscriptionTargetConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscriptionTargetConfig(Consumer<SubscriptionTargetForm.Builder> ... subscriptionTargetConfig) {
            this.subscriptionTargetConfig(Stream.of(subscriptionTargetConfig).map(c -> (SubscriptionTargetForm)((SubscriptionTargetForm.Builder)SubscriptionTargetForm.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSubscriptionTargetRequest build() {
            return new CreateSubscriptionTargetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSubscriptionTargetRequest> {
        public Builder applicableAssetTypes(Collection<String> var1);

        public Builder applicableAssetTypes(String ... var1);

        public Builder authorizedPrincipals(Collection<String> var1);

        public Builder authorizedPrincipals(String ... var1);

        public Builder clientToken(String var1);

        public Builder domainIdentifier(String var1);

        public Builder environmentIdentifier(String var1);

        public Builder manageAccessRole(String var1);

        public Builder name(String var1);

        public Builder provider(String var1);

        public Builder subscriptionTargetConfig(Collection<SubscriptionTargetForm> var1);

        public Builder subscriptionTargetConfig(SubscriptionTargetForm ... var1);

        public Builder subscriptionTargetConfig(Consumer<SubscriptionTargetForm.Builder> ... var1);

        public Builder type(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

