/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.EnvironmentParameter;
import software.amazon.awssdk.services.datazone.model.EnvironmentParametersListCopier;
import software.amazon.awssdk.services.datazone.model.EnvironmentResolvedAccount;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentConfigurationUserParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentConfigurationUserParameter> {
    private static final SdkField<String> ENVIRONMENT_CONFIGURATION_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentConfigurationName").getter(EnvironmentConfigurationUserParameter.getter(EnvironmentConfigurationUserParameter::environmentConfigurationName)).setter(EnvironmentConfigurationUserParameter.setter(Builder::environmentConfigurationName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentConfigurationName").build()).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentId").getter(EnvironmentConfigurationUserParameter.getter(EnvironmentConfigurationUserParameter::environmentId)).setter(EnvironmentConfigurationUserParameter.setter(Builder::environmentId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()).build();
    private static final SdkField<List<EnvironmentParameter>> ENVIRONMENT_PARAMETERS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("environmentParameters").getter(EnvironmentConfigurationUserParameter.getter(EnvironmentConfigurationUserParameter::environmentParameters)).setter(EnvironmentConfigurationUserParameter.setter(Builder::environmentParameters)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(EnvironmentParameter::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<EnvironmentResolvedAccount> ENVIRONMENT_RESOLVED_ACCOUNT_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("environmentResolvedAccount").getter(EnvironmentConfigurationUserParameter.getter(EnvironmentConfigurationUserParameter::environmentResolvedAccount)).setter(EnvironmentConfigurationUserParameter.setter(Builder::environmentResolvedAccount)).constructor(EnvironmentResolvedAccount::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentResolvedAccount").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENVIRONMENT_CONFIGURATION_NAME_FIELD, ENVIRONMENT_ID_FIELD, ENVIRONMENT_PARAMETERS_FIELD, ENVIRONMENT_RESOLVED_ACCOUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnvironmentConfigurationUserParameter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String environmentConfigurationName;
    private final String environmentId;
    private final List<EnvironmentParameter> environmentParameters;
    private final EnvironmentResolvedAccount environmentResolvedAccount;

    private EnvironmentConfigurationUserParameter(BuilderImpl builder) {
        this.environmentConfigurationName = builder.environmentConfigurationName;
        this.environmentId = builder.environmentId;
        this.environmentParameters = builder.environmentParameters;
        this.environmentResolvedAccount = builder.environmentResolvedAccount;
    }

    public final String environmentConfigurationName() {
        return this.environmentConfigurationName;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final boolean hasEnvironmentParameters() {
        return this.environmentParameters != null && !(this.environmentParameters instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentParameter> environmentParameters() {
        return this.environmentParameters;
    }

    public final EnvironmentResolvedAccount environmentResolvedAccount() {
        return this.environmentResolvedAccount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentParameters() ? this.environmentParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentResolvedAccount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentConfigurationUserParameter)) {
            return false;
        }
        EnvironmentConfigurationUserParameter other = (EnvironmentConfigurationUserParameter)obj;
        return Objects.equals(this.environmentConfigurationName(), other.environmentConfigurationName()) && Objects.equals(this.environmentId(), other.environmentId()) && this.hasEnvironmentParameters() == other.hasEnvironmentParameters() && Objects.equals(this.environmentParameters(), other.environmentParameters()) && Objects.equals(this.environmentResolvedAccount(), other.environmentResolvedAccount());
    }

    public final String toString() {
        return ToString.builder("EnvironmentConfigurationUserParameter").add("EnvironmentConfigurationName", this.environmentConfigurationName() == null ? null : "*** Sensitive Data Redacted ***").add("EnvironmentId", this.environmentId()).add("EnvironmentParameters", this.hasEnvironmentParameters() ? this.environmentParameters() : null).add("EnvironmentResolvedAccount", this.environmentResolvedAccount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "environmentConfigurationName": {
                return Optional.ofNullable(clazz.cast(this.environmentConfigurationName()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "environmentParameters": {
                return Optional.ofNullable(clazz.cast(this.environmentParameters()));
            }
            case "environmentResolvedAccount": {
                return Optional.ofNullable(clazz.cast(this.environmentResolvedAccount()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("environmentConfigurationName", ENVIRONMENT_CONFIGURATION_NAME_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("environmentParameters", ENVIRONMENT_PARAMETERS_FIELD);
        map.put("environmentResolvedAccount", ENVIRONMENT_RESOLVED_ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentConfigurationUserParameter, T> g) {
        return obj -> g.apply((EnvironmentConfigurationUserParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String environmentConfigurationName;
        private String environmentId;
        private List<EnvironmentParameter> environmentParameters = DefaultSdkAutoConstructList.getInstance();
        private EnvironmentResolvedAccount environmentResolvedAccount;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentConfigurationUserParameter model) {
            this.environmentConfigurationName(model.environmentConfigurationName);
            this.environmentId(model.environmentId);
            this.environmentParameters(model.environmentParameters);
            this.environmentResolvedAccount(model.environmentResolvedAccount);
        }

        public final String getEnvironmentConfigurationName() {
            return this.environmentConfigurationName;
        }

        public final void setEnvironmentConfigurationName(String environmentConfigurationName) {
            this.environmentConfigurationName = environmentConfigurationName;
        }

        @Override
        public final Builder environmentConfigurationName(String environmentConfigurationName) {
            this.environmentConfigurationName = environmentConfigurationName;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final List<EnvironmentParameter.Builder> getEnvironmentParameters() {
            List<EnvironmentParameter.Builder> result = EnvironmentParametersListCopier.copyToBuilder(this.environmentParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentParameters(Collection<EnvironmentParameter.BuilderImpl> environmentParameters) {
            this.environmentParameters = EnvironmentParametersListCopier.copyFromBuilder(environmentParameters);
        }

        @Override
        public final Builder environmentParameters(Collection<EnvironmentParameter> environmentParameters) {
            this.environmentParameters = EnvironmentParametersListCopier.copy(environmentParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentParameters(EnvironmentParameter ... environmentParameters) {
            this.environmentParameters(Arrays.asList(environmentParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentParameters(Consumer<EnvironmentParameter.Builder> ... environmentParameters) {
            this.environmentParameters(Stream.of(environmentParameters).map(c -> (EnvironmentParameter)((EnvironmentParameter.Builder)EnvironmentParameter.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EnvironmentResolvedAccount.Builder getEnvironmentResolvedAccount() {
            return this.environmentResolvedAccount != null ? this.environmentResolvedAccount.toBuilder() : null;
        }

        public final void setEnvironmentResolvedAccount(EnvironmentResolvedAccount.BuilderImpl environmentResolvedAccount) {
            this.environmentResolvedAccount = environmentResolvedAccount != null ? environmentResolvedAccount.build() : null;
        }

        @Override
        public final Builder environmentResolvedAccount(EnvironmentResolvedAccount environmentResolvedAccount) {
            this.environmentResolvedAccount = environmentResolvedAccount;
            return this;
        }

        @Override
        public EnvironmentConfigurationUserParameter build() {
            return new EnvironmentConfigurationUserParameter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentConfigurationUserParameter> {
        public Builder environmentConfigurationName(String var1);

        public Builder environmentId(String var1);

        public Builder environmentParameters(Collection<EnvironmentParameter> var1);

        public Builder environmentParameters(EnvironmentParameter ... var1);

        public Builder environmentParameters(Consumer<EnvironmentParameter.Builder> ... var1);

        public Builder environmentResolvedAccount(EnvironmentResolvedAccount var1);

        default public Builder environmentResolvedAccount(Consumer<EnvironmentResolvedAccount.Builder> environmentResolvedAccount) {
            return this.environmentResolvedAccount((EnvironmentResolvedAccount)EnvironmentResolvedAccount.builder().applyMutation(environmentResolvedAccount).build());
        }
    }
}

