/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointFormOutput;
import software.amazon.awssdk.services.datazone.model.TimeSeriesEntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTimeSeriesDataPointResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetTimeSeriesDataPointResponse> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainId").getter(GetTimeSeriesDataPointResponse.getter(GetTimeSeriesDataPointResponse::domainId)).setter(GetTimeSeriesDataPointResponse.setter(Builder::domainId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("entityId").getter(GetTimeSeriesDataPointResponse.getter(GetTimeSeriesDataPointResponse::entityId)).setter(GetTimeSeriesDataPointResponse.setter(Builder::entityId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("entityType").getter(GetTimeSeriesDataPointResponse.getter(GetTimeSeriesDataPointResponse::entityTypeAsString)).setter(GetTimeSeriesDataPointResponse.setter(Builder::entityType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()).build();
    private static final SdkField<TimeSeriesDataPointFormOutput> FORM_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("form").getter(GetTimeSeriesDataPointResponse.getter(GetTimeSeriesDataPointResponse::form)).setter(GetTimeSeriesDataPointResponse.setter(Builder::form)).constructor(TimeSeriesDataPointFormOutput::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("form").build()).build();
    private static final SdkField<String> FORM_NAME_FIELD = SdkField.builder(MarshallingType.STRING).memberName("formName").getter(GetTimeSeriesDataPointResponse.getter(GetTimeSeriesDataPointResponse::formName)).setter(GetTimeSeriesDataPointResponse.setter(Builder::formName)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formName").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, ENTITY_ID_FIELD, ENTITY_TYPE_FIELD, FORM_FIELD, FORM_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTimeSeriesDataPointResponse.memberNameToFieldInitializer();
    private final String domainId;
    private final String entityId;
    private final String entityType;
    private final TimeSeriesDataPointFormOutput form;
    private final String formName;

    private GetTimeSeriesDataPointResponse(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.entityId = builder.entityId;
        this.entityType = builder.entityType;
        this.form = builder.form;
        this.formName = builder.formName;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final TimeSeriesEntityType entityType() {
        return TimeSeriesEntityType.fromValue(this.entityType);
    }

    public final String entityTypeAsString() {
        return this.entityType;
    }

    public final TimeSeriesDataPointFormOutput form() {
        return this.form;
    }

    public final String formName() {
        return this.formName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.form());
        hashCode = 31 * hashCode + Objects.hashCode(this.formName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTimeSeriesDataPointResponse)) {
            return false;
        }
        GetTimeSeriesDataPointResponse other = (GetTimeSeriesDataPointResponse)obj;
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityTypeAsString(), other.entityTypeAsString()) && Objects.equals(this.form(), other.form()) && Objects.equals(this.formName(), other.formName());
    }

    public final String toString() {
        return ToString.builder("GetTimeSeriesDataPointResponse").add("DomainId", this.domainId()).add("EntityId", this.entityId()).add("EntityType", this.entityTypeAsString()).add("Form", this.form()).add("FormName", this.formName()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityTypeAsString()));
            }
            case "form": {
                return Optional.ofNullable(clazz.cast(this.form()));
            }
            case "formName": {
                return Optional.ofNullable(clazz.cast(this.formName()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("entityId", ENTITY_ID_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        map.put("form", FORM_FIELD);
        map.put("formName", FORM_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTimeSeriesDataPointResponse, T> g) {
        return obj -> g.apply((GetTimeSeriesDataPointResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private String domainId;
        private String entityId;
        private String entityType;
        private TimeSeriesDataPointFormOutput form;
        private String formName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTimeSeriesDataPointResponse model) {
            super(model);
            this.domainId(model.domainId);
            this.entityId(model.entityId);
            this.entityType(model.entityType);
            this.form(model.form);
            this.formName(model.formName);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(TimeSeriesEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final TimeSeriesDataPointFormOutput.Builder getForm() {
            return this.form != null ? this.form.toBuilder() : null;
        }

        public final void setForm(TimeSeriesDataPointFormOutput.BuilderImpl form) {
            this.form = form != null ? form.build() : null;
        }

        @Override
        public final Builder form(TimeSeriesDataPointFormOutput form) {
            this.form = form;
            return this;
        }

        public final String getFormName() {
            return this.formName;
        }

        public final void setFormName(String formName) {
            this.formName = formName;
        }

        @Override
        public final Builder formName(String formName) {
            this.formName = formName;
            return this;
        }

        @Override
        public GetTimeSeriesDataPointResponse build() {
            return new GetTimeSeriesDataPointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTimeSeriesDataPointResponse> {
        public Builder domainId(String var1);

        public Builder entityId(String var1);

        public Builder entityType(String var1);

        public Builder entityType(TimeSeriesEntityType var1);

        public Builder form(TimeSeriesDataPointFormOutput var1);

        default public Builder form(Consumer<TimeSeriesDataPointFormOutput.Builder> form) {
            return this.form((TimeSeriesDataPointFormOutput)TimeSeriesDataPointFormOutput.builder().applyMutation(form).build());
        }

        public Builder formName(String var1);
    }
}

