/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GroupPolicyGrantPrincipal
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GroupPolicyGrantPrincipal> {
    private static final SdkField<String> GROUP_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("groupIdentifier").getter(GroupPolicyGrantPrincipal.getter(GroupPolicyGrantPrincipal::groupIdentifier)).setter(GroupPolicyGrantPrincipal.setter(Builder::groupIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupIdentifier").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GroupPolicyGrantPrincipal.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String groupIdentifier;
    private final Type type;

    private GroupPolicyGrantPrincipal(BuilderImpl builder) {
        this.groupIdentifier = builder.groupIdentifier;
        this.type = builder.type;
    }

    public final String groupIdentifier() {
        return this.groupIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.groupIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupPolicyGrantPrincipal)) {
            return false;
        }
        GroupPolicyGrantPrincipal other = (GroupPolicyGrantPrincipal)obj;
        return Objects.equals(this.groupIdentifier(), other.groupIdentifier());
    }

    public final String toString() {
        return ToString.builder("GroupPolicyGrantPrincipal").add("GroupIdentifier", this.groupIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "groupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.groupIdentifier()));
            }
        }
        return Optional.empty();
    }

    public static GroupPolicyGrantPrincipal fromGroupIdentifier(String groupIdentifier) {
        return (GroupPolicyGrantPrincipal)GroupPolicyGrantPrincipal.builder().groupIdentifier(groupIdentifier).build();
    }

    public Type type() {
        return this.type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("groupIdentifier", GROUP_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GroupPolicyGrantPrincipal, T> g) {
        return obj -> g.apply((GroupPolicyGrantPrincipal)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String groupIdentifier;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(GroupPolicyGrantPrincipal model) {
            this.groupIdentifier(model.groupIdentifier);
        }

        public final String getGroupIdentifier() {
            return this.groupIdentifier;
        }

        public final void setGroupIdentifier(String groupIdentifier) {
            String oldValue = this.groupIdentifier;
            this.groupIdentifier = groupIdentifier;
            this.handleUnionValueChange(Type.GROUP_IDENTIFIER, oldValue, this.groupIdentifier);
        }

        @Override
        public final Builder groupIdentifier(String groupIdentifier) {
            String oldValue = this.groupIdentifier;
            this.groupIdentifier = groupIdentifier;
            this.handleUnionValueChange(Type.GROUP_IDENTIFIER, oldValue, this.groupIdentifier);
            return this;
        }

        @Override
        public GroupPolicyGrantPrincipal build() {
            return new GroupPolicyGrantPrincipal(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        GROUP_IDENTIFIER,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GroupPolicyGrantPrincipal> {
        public Builder groupIdentifier(String var1);
    }
}

