/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.S3LocationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LakeFormationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LakeFormationConfiguration> {
    private static final SdkField<List<String>> LOCATION_REGISTRATION_EXCLUDE_S3_LOCATIONS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("locationRegistrationExcludeS3Locations").getter(LakeFormationConfiguration.getter(LakeFormationConfiguration::locationRegistrationExcludeS3Locations)).setter(LakeFormationConfiguration.setter(Builder::locationRegistrationExcludeS3Locations)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationRegistrationExcludeS3Locations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> LOCATION_REGISTRATION_ROLE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("locationRegistrationRole").getter(LakeFormationConfiguration.getter(LakeFormationConfiguration::locationRegistrationRole)).setter(LakeFormationConfiguration.setter(Builder::locationRegistrationRole)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locationRegistrationRole").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCATION_REGISTRATION_EXCLUDE_S3_LOCATIONS_FIELD, LOCATION_REGISTRATION_ROLE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LakeFormationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> locationRegistrationExcludeS3Locations;
    private final String locationRegistrationRole;

    private LakeFormationConfiguration(BuilderImpl builder) {
        this.locationRegistrationExcludeS3Locations = builder.locationRegistrationExcludeS3Locations;
        this.locationRegistrationRole = builder.locationRegistrationRole;
    }

    public final boolean hasLocationRegistrationExcludeS3Locations() {
        return this.locationRegistrationExcludeS3Locations != null && !(this.locationRegistrationExcludeS3Locations instanceof SdkAutoConstructList);
    }

    public final List<String> locationRegistrationExcludeS3Locations() {
        return this.locationRegistrationExcludeS3Locations;
    }

    public final String locationRegistrationRole() {
        return this.locationRegistrationRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocationRegistrationExcludeS3Locations() ? this.locationRegistrationExcludeS3Locations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.locationRegistrationRole());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeFormationConfiguration)) {
            return false;
        }
        LakeFormationConfiguration other = (LakeFormationConfiguration)obj;
        return this.hasLocationRegistrationExcludeS3Locations() == other.hasLocationRegistrationExcludeS3Locations() && Objects.equals(this.locationRegistrationExcludeS3Locations(), other.locationRegistrationExcludeS3Locations()) && Objects.equals(this.locationRegistrationRole(), other.locationRegistrationRole());
    }

    public final String toString() {
        return ToString.builder("LakeFormationConfiguration").add("LocationRegistrationExcludeS3Locations", this.hasLocationRegistrationExcludeS3Locations() ? this.locationRegistrationExcludeS3Locations() : null).add("LocationRegistrationRole", this.locationRegistrationRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "locationRegistrationExcludeS3Locations": {
                return Optional.ofNullable(clazz.cast(this.locationRegistrationExcludeS3Locations()));
            }
            case "locationRegistrationRole": {
                return Optional.ofNullable(clazz.cast(this.locationRegistrationRole()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("locationRegistrationExcludeS3Locations", LOCATION_REGISTRATION_EXCLUDE_S3_LOCATIONS_FIELD);
        map.put("locationRegistrationRole", LOCATION_REGISTRATION_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LakeFormationConfiguration, T> g) {
        return obj -> g.apply((LakeFormationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> locationRegistrationExcludeS3Locations = DefaultSdkAutoConstructList.getInstance();
        private String locationRegistrationRole;

        private BuilderImpl() {
        }

        private BuilderImpl(LakeFormationConfiguration model) {
            this.locationRegistrationExcludeS3Locations(model.locationRegistrationExcludeS3Locations);
            this.locationRegistrationRole(model.locationRegistrationRole);
        }

        public final Collection<String> getLocationRegistrationExcludeS3Locations() {
            if (this.locationRegistrationExcludeS3Locations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.locationRegistrationExcludeS3Locations;
        }

        public final void setLocationRegistrationExcludeS3Locations(Collection<String> locationRegistrationExcludeS3Locations) {
            this.locationRegistrationExcludeS3Locations = S3LocationListCopier.copy(locationRegistrationExcludeS3Locations);
        }

        @Override
        public final Builder locationRegistrationExcludeS3Locations(Collection<String> locationRegistrationExcludeS3Locations) {
            this.locationRegistrationExcludeS3Locations = S3LocationListCopier.copy(locationRegistrationExcludeS3Locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locationRegistrationExcludeS3Locations(String ... locationRegistrationExcludeS3Locations) {
            this.locationRegistrationExcludeS3Locations(Arrays.asList(locationRegistrationExcludeS3Locations));
            return this;
        }

        public final String getLocationRegistrationRole() {
            return this.locationRegistrationRole;
        }

        public final void setLocationRegistrationRole(String locationRegistrationRole) {
            this.locationRegistrationRole = locationRegistrationRole;
        }

        @Override
        public final Builder locationRegistrationRole(String locationRegistrationRole) {
            this.locationRegistrationRole = locationRegistrationRole;
            return this;
        }

        @Override
        public LakeFormationConfiguration build() {
            return new LakeFormationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LakeFormationConfiguration> {
        public Builder locationRegistrationExcludeS3Locations(Collection<String> var1);

        public Builder locationRegistrationExcludeS3Locations(String ... var1);

        public Builder locationRegistrationRole(String var1);
    }
}

