/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTermsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListingSummaryItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListingSummaryItem> {
    private static final SdkField<List<DetailedGlossaryTerm>> GLOSSARY_TERMS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("glossaryTerms").getter(ListingSummaryItem.getter(ListingSummaryItem::glossaryTerms)).setter(ListingSummaryItem.setter(Builder::glossaryTerms)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(DetailedGlossaryTerm::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> LISTING_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("listingId").getter(ListingSummaryItem.getter(ListingSummaryItem::listingId)).setter(ListingSummaryItem.setter(Builder::listingId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingId").build()).build();
    private static final SdkField<String> LISTING_REVISION_FIELD = SdkField.builder(MarshallingType.STRING).memberName("listingRevision").getter(ListingSummaryItem.getter(ListingSummaryItem::listingRevision)).setter(ListingSummaryItem.setter(Builder::listingRevision)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listingRevision").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLOSSARY_TERMS_FIELD, LISTING_ID_FIELD, LISTING_REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListingSummaryItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<DetailedGlossaryTerm> glossaryTerms;
    private final String listingId;
    private final String listingRevision;

    private ListingSummaryItem(BuilderImpl builder) {
        this.glossaryTerms = builder.glossaryTerms;
        this.listingId = builder.listingId;
        this.listingRevision = builder.listingRevision;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<DetailedGlossaryTerm> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String listingId() {
        return this.listingId;
    }

    public final String listingRevision() {
        return this.listingRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.listingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.listingRevision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListingSummaryItem)) {
            return false;
        }
        ListingSummaryItem other = (ListingSummaryItem)obj;
        return this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.listingId(), other.listingId()) && Objects.equals(this.listingRevision(), other.listingRevision());
    }

    public final String toString() {
        return ToString.builder("ListingSummaryItem").add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("ListingId", this.listingId()).add("ListingRevision", this.listingRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "listingId": {
                return Optional.ofNullable(clazz.cast(this.listingId()));
            }
            case "listingRevision": {
                return Optional.ofNullable(clazz.cast(this.listingRevision()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("listingId", LISTING_ID_FIELD);
        map.put("listingRevision", LISTING_REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListingSummaryItem, T> g) {
        return obj -> g.apply((ListingSummaryItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<DetailedGlossaryTerm> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String listingId;
        private String listingRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(ListingSummaryItem model) {
            this.glossaryTerms(model.glossaryTerms);
            this.listingId(model.listingId);
            this.listingRevision(model.listingRevision);
        }

        public final List<DetailedGlossaryTerm.Builder> getGlossaryTerms() {
            List<DetailedGlossaryTerm.Builder> result = DetailedGlossaryTermsCopier.copyToBuilder(this.glossaryTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlossaryTerms(Collection<DetailedGlossaryTerm.BuilderImpl> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copyFromBuilder(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(DetailedGlossaryTerm ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... glossaryTerms) {
            this.glossaryTerms(Stream.of(glossaryTerms).map(c -> (DetailedGlossaryTerm)((DetailedGlossaryTerm.Builder)DetailedGlossaryTerm.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getListingId() {
            return this.listingId;
        }

        public final void setListingId(String listingId) {
            this.listingId = listingId;
        }

        @Override
        public final Builder listingId(String listingId) {
            this.listingId = listingId;
            return this;
        }

        public final String getListingRevision() {
            return this.listingRevision;
        }

        public final void setListingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
        }

        @Override
        public final Builder listingRevision(String listingRevision) {
            this.listingRevision = listingRevision;
            return this;
        }

        @Override
        public ListingSummaryItem build() {
            return new ListingSummaryItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListingSummaryItem> {
        public Builder glossaryTerms(Collection<DetailedGlossaryTerm> var1);

        public Builder glossaryTerms(DetailedGlossaryTerm ... var1);

        public Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... var1);

        public Builder listingId(String var1);

        public Builder listingRevision(String var1);
    }
}

