/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OAuth2ClientApplication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OAuth2ClientApplication> {
    private static final SdkField<String> AWS_MANAGED_CLIENT_APPLICATION_REFERENCE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("aWSManagedClientApplicationReference").getter(OAuth2ClientApplication.getter(OAuth2ClientApplication::awsManagedClientApplicationReference)).setter(OAuth2ClientApplication.setter(Builder::awsManagedClientApplicationReference)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aWSManagedClientApplicationReference").build()).build();
    private static final SdkField<String> USER_MANAGED_CLIENT_APPLICATION_CLIENT_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("userManagedClientApplicationClientId").getter(OAuth2ClientApplication.getter(OAuth2ClientApplication::userManagedClientApplicationClientId)).setter(OAuth2ClientApplication.setter(Builder::userManagedClientApplicationClientId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userManagedClientApplicationClientId").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_MANAGED_CLIENT_APPLICATION_REFERENCE_FIELD, USER_MANAGED_CLIENT_APPLICATION_CLIENT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OAuth2ClientApplication.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String awsManagedClientApplicationReference;
    private final String userManagedClientApplicationClientId;

    private OAuth2ClientApplication(BuilderImpl builder) {
        this.awsManagedClientApplicationReference = builder.awsManagedClientApplicationReference;
        this.userManagedClientApplicationClientId = builder.userManagedClientApplicationClientId;
    }

    public final String awsManagedClientApplicationReference() {
        return this.awsManagedClientApplicationReference;
    }

    public final String userManagedClientApplicationClientId() {
        return this.userManagedClientApplicationClientId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsManagedClientApplicationReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.userManagedClientApplicationClientId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2ClientApplication)) {
            return false;
        }
        OAuth2ClientApplication other = (OAuth2ClientApplication)obj;
        return Objects.equals(this.awsManagedClientApplicationReference(), other.awsManagedClientApplicationReference()) && Objects.equals(this.userManagedClientApplicationClientId(), other.userManagedClientApplicationClientId());
    }

    public final String toString() {
        return ToString.builder("OAuth2ClientApplication").add("AWSManagedClientApplicationReference", this.awsManagedClientApplicationReference()).add("UserManagedClientApplicationClientId", this.userManagedClientApplicationClientId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aWSManagedClientApplicationReference": {
                return Optional.ofNullable(clazz.cast(this.awsManagedClientApplicationReference()));
            }
            case "userManagedClientApplicationClientId": {
                return Optional.ofNullable(clazz.cast(this.userManagedClientApplicationClientId()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("aWSManagedClientApplicationReference", AWS_MANAGED_CLIENT_APPLICATION_REFERENCE_FIELD);
        map.put("userManagedClientApplicationClientId", USER_MANAGED_CLIENT_APPLICATION_CLIENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OAuth2ClientApplication, T> g) {
        return obj -> g.apply((OAuth2ClientApplication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsManagedClientApplicationReference;
        private String userManagedClientApplicationClientId;

        private BuilderImpl() {
        }

        private BuilderImpl(OAuth2ClientApplication model) {
            this.awsManagedClientApplicationReference(model.awsManagedClientApplicationReference);
            this.userManagedClientApplicationClientId(model.userManagedClientApplicationClientId);
        }

        public final String getAwsManagedClientApplicationReference() {
            return this.awsManagedClientApplicationReference;
        }

        public final void setAwsManagedClientApplicationReference(String awsManagedClientApplicationReference) {
            this.awsManagedClientApplicationReference = awsManagedClientApplicationReference;
        }

        @Override
        public final Builder awsManagedClientApplicationReference(String awsManagedClientApplicationReference) {
            this.awsManagedClientApplicationReference = awsManagedClientApplicationReference;
            return this;
        }

        public final String getUserManagedClientApplicationClientId() {
            return this.userManagedClientApplicationClientId;
        }

        public final void setUserManagedClientApplicationClientId(String userManagedClientApplicationClientId) {
            this.userManagedClientApplicationClientId = userManagedClientApplicationClientId;
        }

        @Override
        public final Builder userManagedClientApplicationClientId(String userManagedClientApplicationClientId) {
            this.userManagedClientApplicationClientId = userManagedClientApplicationClientId;
            return this;
        }

        @Override
        public OAuth2ClientApplication build() {
            return new OAuth2ClientApplication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OAuth2ClientApplication> {
        public Builder awsManagedClientApplicationReference(String var1);

        public Builder userManagedClientApplicationClientId(String var1);
    }
}

