/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.EnabledRegionListCopier;
import software.amazon.awssdk.services.datazone.model.GlobalParameterMapCopier;
import software.amazon.awssdk.services.datazone.model.ProvisioningConfiguration;
import software.amazon.awssdk.services.datazone.model.ProvisioningConfigurationListCopier;
import software.amazon.awssdk.services.datazone.model.RegionalParameterMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEnvironmentBlueprintConfigurationRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, PutEnvironmentBlueprintConfigurationRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("domainIdentifier").getter(PutEnvironmentBlueprintConfigurationRequest.getter(PutEnvironmentBlueprintConfigurationRequest::domainIdentifier)).setter(PutEnvironmentBlueprintConfigurationRequest.setter(Builder::domainIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()).build();
    private static final SdkField<List<String>> ENABLED_REGIONS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("enabledRegions").getter(PutEnvironmentBlueprintConfigurationRequest.getter(PutEnvironmentBlueprintConfigurationRequest::enabledRegions)).setter(PutEnvironmentBlueprintConfigurationRequest.setter(Builder::enabledRegions)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentBlueprintIdentifier").getter(PutEnvironmentBlueprintConfigurationRequest.getter(PutEnvironmentBlueprintConfigurationRequest::environmentBlueprintIdentifier)).setter(PutEnvironmentBlueprintConfigurationRequest.setter(Builder::environmentBlueprintIdentifier)).traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("environmentBlueprintIdentifier").build()).build();
    private static final SdkField<String> ENVIRONMENT_ROLE_PERMISSION_BOUNDARY_FIELD = SdkField.builder(MarshallingType.STRING).memberName("environmentRolePermissionBoundary").getter(PutEnvironmentBlueprintConfigurationRequest.getter(PutEnvironmentBlueprintConfigurationRequest::environmentRolePermissionBoundary)).setter(PutEnvironmentBlueprintConfigurationRequest.setter(Builder::environmentRolePermissionBoundary)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentRolePermissionBoundary").build()).build();
    private static final SdkField<Map<String, String>> GLOBAL_PARAMETERS_FIELD = SdkField.builder(MarshallingType.MAP).memberName("globalParameters").getter(PutEnvironmentBlueprintConfigurationRequest.getter(PutEnvironmentBlueprintConfigurationRequest::globalParameters)).setter(PutEnvironmentBlueprintConfigurationRequest.setter(Builder::globalParameters)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build();
    private static final SdkField<String> MANAGE_ACCESS_ROLE_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("manageAccessRoleArn").getter(PutEnvironmentBlueprintConfigurationRequest.getter(PutEnvironmentBlueprintConfigurationRequest::manageAccessRoleArn)).setter(PutEnvironmentBlueprintConfigurationRequest.setter(Builder::manageAccessRoleArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageAccessRoleArn").build()).build();
    private static final SdkField<List<ProvisioningConfiguration>> PROVISIONING_CONFIGURATIONS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("provisioningConfigurations").getter(PutEnvironmentBlueprintConfigurationRequest.getter(PutEnvironmentBlueprintConfigurationRequest::provisioningConfigurations)).setter(PutEnvironmentBlueprintConfigurationRequest.setter(Builder::provisioningConfigurations)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(ProvisioningConfiguration::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final SdkField<String> PROVISIONING_ROLE_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("provisioningRoleArn").getter(PutEnvironmentBlueprintConfigurationRequest.getter(PutEnvironmentBlueprintConfigurationRequest::provisioningRoleArn)).setter(PutEnvironmentBlueprintConfigurationRequest.setter(Builder::provisioningRoleArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRoleArn").build()).build();
    private static final SdkField<Map<String, Map<String, String>>> REGIONAL_PARAMETERS_FIELD = SdkField.builder(MarshallingType.MAP).memberName("regionalParameters").getter(PutEnvironmentBlueprintConfigurationRequest.getter(PutEnvironmentBlueprintConfigurationRequest::regionalParameters)).setter(PutEnvironmentBlueprintConfigurationRequest.setter(Builder::regionalParameters)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.MAP).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD, ENABLED_REGIONS_FIELD, ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD, ENVIRONMENT_ROLE_PERMISSION_BOUNDARY_FIELD, GLOBAL_PARAMETERS_FIELD, MANAGE_ACCESS_ROLE_ARN_FIELD, PROVISIONING_CONFIGURATIONS_FIELD, PROVISIONING_ROLE_ARN_FIELD, REGIONAL_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutEnvironmentBlueprintConfigurationRequest.memberNameToFieldInitializer();
    private final String domainIdentifier;
    private final List<String> enabledRegions;
    private final String environmentBlueprintIdentifier;
    private final String environmentRolePermissionBoundary;
    private final Map<String, String> globalParameters;
    private final String manageAccessRoleArn;
    private final List<ProvisioningConfiguration> provisioningConfigurations;
    private final String provisioningRoleArn;
    private final Map<String, Map<String, String>> regionalParameters;

    private PutEnvironmentBlueprintConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.enabledRegions = builder.enabledRegions;
        this.environmentBlueprintIdentifier = builder.environmentBlueprintIdentifier;
        this.environmentRolePermissionBoundary = builder.environmentRolePermissionBoundary;
        this.globalParameters = builder.globalParameters;
        this.manageAccessRoleArn = builder.manageAccessRoleArn;
        this.provisioningConfigurations = builder.provisioningConfigurations;
        this.provisioningRoleArn = builder.provisioningRoleArn;
        this.regionalParameters = builder.regionalParameters;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final boolean hasEnabledRegions() {
        return this.enabledRegions != null && !(this.enabledRegions instanceof SdkAutoConstructList);
    }

    public final List<String> enabledRegions() {
        return this.enabledRegions;
    }

    public final String environmentBlueprintIdentifier() {
        return this.environmentBlueprintIdentifier;
    }

    public final String environmentRolePermissionBoundary() {
        return this.environmentRolePermissionBoundary;
    }

    public final boolean hasGlobalParameters() {
        return this.globalParameters != null && !(this.globalParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> globalParameters() {
        return this.globalParameters;
    }

    public final String manageAccessRoleArn() {
        return this.manageAccessRoleArn;
    }

    public final boolean hasProvisioningConfigurations() {
        return this.provisioningConfigurations != null && !(this.provisioningConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ProvisioningConfiguration> provisioningConfigurations() {
        return this.provisioningConfigurations;
    }

    public final String provisioningRoleArn() {
        return this.provisioningRoleArn;
    }

    public final boolean hasRegionalParameters() {
        return this.regionalParameters != null && !(this.regionalParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> regionalParameters() {
        return this.regionalParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledRegions() ? this.enabledRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentBlueprintIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentRolePermissionBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlobalParameters() ? this.globalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.manageAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisioningConfigurations() ? this.provisioningConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionalParameters() ? this.regionalParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEnvironmentBlueprintConfigurationRequest)) {
            return false;
        }
        PutEnvironmentBlueprintConfigurationRequest other = (PutEnvironmentBlueprintConfigurationRequest)obj;
        return Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && this.hasEnabledRegions() == other.hasEnabledRegions() && Objects.equals(this.enabledRegions(), other.enabledRegions()) && Objects.equals(this.environmentBlueprintIdentifier(), other.environmentBlueprintIdentifier()) && Objects.equals(this.environmentRolePermissionBoundary(), other.environmentRolePermissionBoundary()) && this.hasGlobalParameters() == other.hasGlobalParameters() && Objects.equals(this.globalParameters(), other.globalParameters()) && Objects.equals(this.manageAccessRoleArn(), other.manageAccessRoleArn()) && this.hasProvisioningConfigurations() == other.hasProvisioningConfigurations() && Objects.equals(this.provisioningConfigurations(), other.provisioningConfigurations()) && Objects.equals(this.provisioningRoleArn(), other.provisioningRoleArn()) && this.hasRegionalParameters() == other.hasRegionalParameters() && Objects.equals(this.regionalParameters(), other.regionalParameters());
    }

    public final String toString() {
        return ToString.builder("PutEnvironmentBlueprintConfigurationRequest").add("DomainIdentifier", this.domainIdentifier()).add("EnabledRegions", this.hasEnabledRegions() ? this.enabledRegions() : null).add("EnvironmentBlueprintIdentifier", this.environmentBlueprintIdentifier()).add("EnvironmentRolePermissionBoundary", this.environmentRolePermissionBoundary()).add("GlobalParameters", this.hasGlobalParameters() ? this.globalParameters() : null).add("ManageAccessRoleArn", this.manageAccessRoleArn()).add("ProvisioningConfigurations", this.hasProvisioningConfigurations() ? this.provisioningConfigurations() : null).add("ProvisioningRoleArn", this.provisioningRoleArn()).add("RegionalParameters", this.hasRegionalParameters() ? this.regionalParameters() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "enabledRegions": {
                return Optional.ofNullable(clazz.cast(this.enabledRegions()));
            }
            case "environmentBlueprintIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentBlueprintIdentifier()));
            }
            case "environmentRolePermissionBoundary": {
                return Optional.ofNullable(clazz.cast(this.environmentRolePermissionBoundary()));
            }
            case "globalParameters": {
                return Optional.ofNullable(clazz.cast(this.globalParameters()));
            }
            case "manageAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.manageAccessRoleArn()));
            }
            case "provisioningConfigurations": {
                return Optional.ofNullable(clazz.cast(this.provisioningConfigurations()));
            }
            case "provisioningRoleArn": {
                return Optional.ofNullable(clazz.cast(this.provisioningRoleArn()));
            }
            case "regionalParameters": {
                return Optional.ofNullable(clazz.cast(this.regionalParameters()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("enabledRegions", ENABLED_REGIONS_FIELD);
        map.put("environmentBlueprintIdentifier", ENVIRONMENT_BLUEPRINT_IDENTIFIER_FIELD);
        map.put("environmentRolePermissionBoundary", ENVIRONMENT_ROLE_PERMISSION_BOUNDARY_FIELD);
        map.put("globalParameters", GLOBAL_PARAMETERS_FIELD);
        map.put("manageAccessRoleArn", MANAGE_ACCESS_ROLE_ARN_FIELD);
        map.put("provisioningConfigurations", PROVISIONING_CONFIGURATIONS_FIELD);
        map.put("provisioningRoleArn", PROVISIONING_ROLE_ARN_FIELD);
        map.put("regionalParameters", REGIONAL_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutEnvironmentBlueprintConfigurationRequest, T> g) {
        return obj -> g.apply((PutEnvironmentBlueprintConfigurationRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String domainIdentifier;
        private List<String> enabledRegions = DefaultSdkAutoConstructList.getInstance();
        private String environmentBlueprintIdentifier;
        private String environmentRolePermissionBoundary;
        private Map<String, String> globalParameters = DefaultSdkAutoConstructMap.getInstance();
        private String manageAccessRoleArn;
        private List<ProvisioningConfiguration> provisioningConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String provisioningRoleArn;
        private Map<String, Map<String, String>> regionalParameters = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEnvironmentBlueprintConfigurationRequest model) {
            super(model);
            this.domainIdentifier(model.domainIdentifier);
            this.enabledRegions(model.enabledRegions);
            this.environmentBlueprintIdentifier(model.environmentBlueprintIdentifier);
            this.environmentRolePermissionBoundary(model.environmentRolePermissionBoundary);
            this.globalParameters(model.globalParameters);
            this.manageAccessRoleArn(model.manageAccessRoleArn);
            this.provisioningConfigurations(model.provisioningConfigurations);
            this.provisioningRoleArn(model.provisioningRoleArn);
            this.regionalParameters(model.regionalParameters);
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Collection<String> getEnabledRegions() {
            if (this.enabledRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledRegions;
        }

        public final void setEnabledRegions(Collection<String> enabledRegions) {
            this.enabledRegions = EnabledRegionListCopier.copy(enabledRegions);
        }

        @Override
        public final Builder enabledRegions(Collection<String> enabledRegions) {
            this.enabledRegions = EnabledRegionListCopier.copy(enabledRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledRegions(String ... enabledRegions) {
            this.enabledRegions(Arrays.asList(enabledRegions));
            return this;
        }

        public final String getEnvironmentBlueprintIdentifier() {
            return this.environmentBlueprintIdentifier;
        }

        public final void setEnvironmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
        }

        @Override
        public final Builder environmentBlueprintIdentifier(String environmentBlueprintIdentifier) {
            this.environmentBlueprintIdentifier = environmentBlueprintIdentifier;
            return this;
        }

        public final String getEnvironmentRolePermissionBoundary() {
            return this.environmentRolePermissionBoundary;
        }

        public final void setEnvironmentRolePermissionBoundary(String environmentRolePermissionBoundary) {
            this.environmentRolePermissionBoundary = environmentRolePermissionBoundary;
        }

        @Override
        public final Builder environmentRolePermissionBoundary(String environmentRolePermissionBoundary) {
            this.environmentRolePermissionBoundary = environmentRolePermissionBoundary;
            return this;
        }

        public final Map<String, String> getGlobalParameters() {
            if (this.globalParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.globalParameters;
        }

        public final void setGlobalParameters(Map<String, String> globalParameters) {
            this.globalParameters = GlobalParameterMapCopier.copy(globalParameters);
        }

        @Override
        public final Builder globalParameters(Map<String, String> globalParameters) {
            this.globalParameters = GlobalParameterMapCopier.copy(globalParameters);
            return this;
        }

        public final String getManageAccessRoleArn() {
            return this.manageAccessRoleArn;
        }

        public final void setManageAccessRoleArn(String manageAccessRoleArn) {
            this.manageAccessRoleArn = manageAccessRoleArn;
        }

        @Override
        public final Builder manageAccessRoleArn(String manageAccessRoleArn) {
            this.manageAccessRoleArn = manageAccessRoleArn;
            return this;
        }

        public final List<ProvisioningConfiguration.Builder> getProvisioningConfigurations() {
            List<ProvisioningConfiguration.Builder> result = ProvisioningConfigurationListCopier.copyToBuilder(this.provisioningConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningConfigurations(Collection<ProvisioningConfiguration.BuilderImpl> provisioningConfigurations) {
            this.provisioningConfigurations = ProvisioningConfigurationListCopier.copyFromBuilder(provisioningConfigurations);
        }

        @Override
        public final Builder provisioningConfigurations(Collection<ProvisioningConfiguration> provisioningConfigurations) {
            this.provisioningConfigurations = ProvisioningConfigurationListCopier.copy(provisioningConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningConfigurations(ProvisioningConfiguration ... provisioningConfigurations) {
            this.provisioningConfigurations(Arrays.asList(provisioningConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningConfigurations(Consumer<ProvisioningConfiguration.Builder> ... provisioningConfigurations) {
            this.provisioningConfigurations(Stream.of(provisioningConfigurations).map(c -> (ProvisioningConfiguration)((ProvisioningConfiguration.Builder)ProvisioningConfiguration.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProvisioningRoleArn() {
            return this.provisioningRoleArn;
        }

        public final void setProvisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
        }

        @Override
        public final Builder provisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getRegionalParameters() {
            if (this.regionalParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.regionalParameters;
        }

        public final void setRegionalParameters(Map<String, ? extends Map<String, String>> regionalParameters) {
            this.regionalParameters = RegionalParameterMapCopier.copy(regionalParameters);
        }

        @Override
        public final Builder regionalParameters(Map<String, ? extends Map<String, String>> regionalParameters) {
            this.regionalParameters = RegionalParameterMapCopier.copy(regionalParameters);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEnvironmentBlueprintConfigurationRequest build() {
            return new PutEnvironmentBlueprintConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEnvironmentBlueprintConfigurationRequest> {
        public Builder domainIdentifier(String var1);

        public Builder enabledRegions(Collection<String> var1);

        public Builder enabledRegions(String ... var1);

        public Builder environmentBlueprintIdentifier(String var1);

        public Builder environmentRolePermissionBoundary(String var1);

        public Builder globalParameters(Map<String, String> var1);

        public Builder manageAccessRoleArn(String var1);

        public Builder provisioningConfigurations(Collection<ProvisioningConfiguration> var1);

        public Builder provisioningConfigurations(ProvisioningConfiguration ... var1);

        public Builder provisioningConfigurations(Consumer<ProvisioningConfiguration.Builder> ... var1);

        public Builder provisioningRoleArn(String var1);

        public Builder regionalParameters(Map<String, ? extends Map<String, String>> var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

