/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.EqualToExpression;
import software.amazon.awssdk.services.datazone.model.GreaterThanExpression;
import software.amazon.awssdk.services.datazone.model.GreaterThanOrEqualToExpression;
import software.amazon.awssdk.services.datazone.model.InExpression;
import software.amazon.awssdk.services.datazone.model.IsNotNullExpression;
import software.amazon.awssdk.services.datazone.model.IsNullExpression;
import software.amazon.awssdk.services.datazone.model.LessThanExpression;
import software.amazon.awssdk.services.datazone.model.LessThanOrEqualToExpression;
import software.amazon.awssdk.services.datazone.model.LikeExpression;
import software.amazon.awssdk.services.datazone.model.NotEqualToExpression;
import software.amazon.awssdk.services.datazone.model.NotInExpression;
import software.amazon.awssdk.services.datazone.model.NotLikeExpression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RowFilterExpression
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RowFilterExpression> {
    private static final SdkField<EqualToExpression> EQUAL_TO_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("equalTo").getter(RowFilterExpression.getter(RowFilterExpression::equalTo)).setter(RowFilterExpression.setter(Builder::equalTo)).constructor(EqualToExpression::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equalTo").build()).build();
    private static final SdkField<GreaterThanExpression> GREATER_THAN_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("greaterThan").getter(RowFilterExpression.getter(RowFilterExpression::greaterThan)).setter(RowFilterExpression.setter(Builder::greaterThan)).constructor(GreaterThanExpression::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThan").build()).build();
    private static final SdkField<GreaterThanOrEqualToExpression> GREATER_THAN_OR_EQUAL_TO_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("greaterThanOrEqualTo").getter(RowFilterExpression.getter(RowFilterExpression::greaterThanOrEqualTo)).setter(RowFilterExpression.setter(Builder::greaterThanOrEqualTo)).constructor(GreaterThanOrEqualToExpression::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("greaterThanOrEqualTo").build()).build();
    private static final SdkField<InExpression> IN_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("in").getter(RowFilterExpression.getter(RowFilterExpression::in)).setter(RowFilterExpression.setter(Builder::in)).constructor(InExpression::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("in").build()).build();
    private static final SdkField<IsNotNullExpression> IS_NOT_NULL_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("isNotNull").getter(RowFilterExpression.getter(RowFilterExpression::isNotNull)).setter(RowFilterExpression.setter(Builder::isNotNull)).constructor(IsNotNullExpression::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNotNull").build()).build();
    private static final SdkField<IsNullExpression> IS_NULL_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("isNull").getter(RowFilterExpression.getter(RowFilterExpression::isNull)).setter(RowFilterExpression.setter(Builder::isNull)).constructor(IsNullExpression::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNull").build()).build();
    private static final SdkField<LessThanExpression> LESS_THAN_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("lessThan").getter(RowFilterExpression.getter(RowFilterExpression::lessThan)).setter(RowFilterExpression.setter(Builder::lessThan)).constructor(LessThanExpression::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThan").build()).build();
    private static final SdkField<LessThanOrEqualToExpression> LESS_THAN_OR_EQUAL_TO_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("lessThanOrEqualTo").getter(RowFilterExpression.getter(RowFilterExpression::lessThanOrEqualTo)).setter(RowFilterExpression.setter(Builder::lessThanOrEqualTo)).constructor(LessThanOrEqualToExpression::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lessThanOrEqualTo").build()).build();
    private static final SdkField<LikeExpression> LIKE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("like").getter(RowFilterExpression.getter(RowFilterExpression::like)).setter(RowFilterExpression.setter(Builder::like)).constructor(LikeExpression::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("like").build()).build();
    private static final SdkField<NotEqualToExpression> NOT_EQUAL_TO_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("notEqualTo").getter(RowFilterExpression.getter(RowFilterExpression::notEqualTo)).setter(RowFilterExpression.setter(Builder::notEqualTo)).constructor(NotEqualToExpression::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEqualTo").build()).build();
    private static final SdkField<NotInExpression> NOT_IN_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("notIn").getter(RowFilterExpression.getter(RowFilterExpression::notIn)).setter(RowFilterExpression.setter(Builder::notIn)).constructor(NotInExpression::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notIn").build()).build();
    private static final SdkField<NotLikeExpression> NOT_LIKE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("notLike").getter(RowFilterExpression.getter(RowFilterExpression::notLike)).setter(RowFilterExpression.setter(Builder::notLike)).constructor(NotLikeExpression::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notLike").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQUAL_TO_FIELD, GREATER_THAN_FIELD, GREATER_THAN_OR_EQUAL_TO_FIELD, IN_FIELD, IS_NOT_NULL_FIELD, IS_NULL_FIELD, LESS_THAN_FIELD, LESS_THAN_OR_EQUAL_TO_FIELD, LIKE_FIELD, NOT_EQUAL_TO_FIELD, NOT_IN_FIELD, NOT_LIKE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RowFilterExpression.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EqualToExpression equalTo;
    private final GreaterThanExpression greaterThan;
    private final GreaterThanOrEqualToExpression greaterThanOrEqualTo;
    private final InExpression in;
    private final IsNotNullExpression isNotNull;
    private final IsNullExpression isNull;
    private final LessThanExpression lessThan;
    private final LessThanOrEqualToExpression lessThanOrEqualTo;
    private final LikeExpression like;
    private final NotEqualToExpression notEqualTo;
    private final NotInExpression notIn;
    private final NotLikeExpression notLike;
    private final Type type;

    private RowFilterExpression(BuilderImpl builder) {
        this.equalTo = builder.equalTo;
        this.greaterThan = builder.greaterThan;
        this.greaterThanOrEqualTo = builder.greaterThanOrEqualTo;
        this.in = builder.in;
        this.isNotNull = builder.isNotNull;
        this.isNull = builder.isNull;
        this.lessThan = builder.lessThan;
        this.lessThanOrEqualTo = builder.lessThanOrEqualTo;
        this.like = builder.like;
        this.notEqualTo = builder.notEqualTo;
        this.notIn = builder.notIn;
        this.notLike = builder.notLike;
        this.type = builder.type;
    }

    public final EqualToExpression equalTo() {
        return this.equalTo;
    }

    public final GreaterThanExpression greaterThan() {
        return this.greaterThan;
    }

    public final GreaterThanOrEqualToExpression greaterThanOrEqualTo() {
        return this.greaterThanOrEqualTo;
    }

    public final InExpression in() {
        return this.in;
    }

    public final IsNotNullExpression isNotNull() {
        return this.isNotNull;
    }

    public final IsNullExpression isNull() {
        return this.isNull;
    }

    public final LessThanExpression lessThan() {
        return this.lessThan;
    }

    public final LessThanOrEqualToExpression lessThanOrEqualTo() {
        return this.lessThanOrEqualTo;
    }

    public final LikeExpression like() {
        return this.like;
    }

    public final NotEqualToExpression notEqualTo() {
        return this.notEqualTo;
    }

    public final NotInExpression notIn() {
        return this.notIn;
    }

    public final NotLikeExpression notLike() {
        return this.notLike;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.equalTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.greaterThan());
        hashCode = 31 * hashCode + Objects.hashCode(this.greaterThanOrEqualTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.in());
        hashCode = 31 * hashCode + Objects.hashCode(this.isNotNull());
        hashCode = 31 * hashCode + Objects.hashCode(this.isNull());
        hashCode = 31 * hashCode + Objects.hashCode(this.lessThan());
        hashCode = 31 * hashCode + Objects.hashCode(this.lessThanOrEqualTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.like());
        hashCode = 31 * hashCode + Objects.hashCode(this.notEqualTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.notIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.notLike());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowFilterExpression)) {
            return false;
        }
        RowFilterExpression other = (RowFilterExpression)obj;
        return Objects.equals(this.equalTo(), other.equalTo()) && Objects.equals(this.greaterThan(), other.greaterThan()) && Objects.equals(this.greaterThanOrEqualTo(), other.greaterThanOrEqualTo()) && Objects.equals(this.in(), other.in()) && Objects.equals(this.isNotNull(), other.isNotNull()) && Objects.equals(this.isNull(), other.isNull()) && Objects.equals(this.lessThan(), other.lessThan()) && Objects.equals(this.lessThanOrEqualTo(), other.lessThanOrEqualTo()) && Objects.equals(this.like(), other.like()) && Objects.equals(this.notEqualTo(), other.notEqualTo()) && Objects.equals(this.notIn(), other.notIn()) && Objects.equals(this.notLike(), other.notLike());
    }

    public final String toString() {
        return ToString.builder("RowFilterExpression").add("EqualTo", this.equalTo()).add("GreaterThan", this.greaterThan()).add("GreaterThanOrEqualTo", this.greaterThanOrEqualTo()).add("In", this.in()).add("IsNotNull", this.isNotNull()).add("IsNull", this.isNull()).add("LessThan", this.lessThan()).add("LessThanOrEqualTo", this.lessThanOrEqualTo()).add("Like", this.like()).add("NotEqualTo", this.notEqualTo()).add("NotIn", this.notIn()).add("NotLike", this.notLike()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "equalTo": {
                return Optional.ofNullable(clazz.cast(this.equalTo()));
            }
            case "greaterThan": {
                return Optional.ofNullable(clazz.cast(this.greaterThan()));
            }
            case "greaterThanOrEqualTo": {
                return Optional.ofNullable(clazz.cast(this.greaterThanOrEqualTo()));
            }
            case "in": {
                return Optional.ofNullable(clazz.cast(this.in()));
            }
            case "isNotNull": {
                return Optional.ofNullable(clazz.cast(this.isNotNull()));
            }
            case "isNull": {
                return Optional.ofNullable(clazz.cast(this.isNull()));
            }
            case "lessThan": {
                return Optional.ofNullable(clazz.cast(this.lessThan()));
            }
            case "lessThanOrEqualTo": {
                return Optional.ofNullable(clazz.cast(this.lessThanOrEqualTo()));
            }
            case "like": {
                return Optional.ofNullable(clazz.cast(this.like()));
            }
            case "notEqualTo": {
                return Optional.ofNullable(clazz.cast(this.notEqualTo()));
            }
            case "notIn": {
                return Optional.ofNullable(clazz.cast(this.notIn()));
            }
            case "notLike": {
                return Optional.ofNullable(clazz.cast(this.notLike()));
            }
        }
        return Optional.empty();
    }

    public static RowFilterExpression fromEqualTo(EqualToExpression equalTo) {
        return (RowFilterExpression)RowFilterExpression.builder().equalTo(equalTo).build();
    }

    public static RowFilterExpression fromEqualTo(Consumer<EqualToExpression.Builder> equalTo) {
        EqualToExpression.Builder builder = EqualToExpression.builder();
        equalTo.accept(builder);
        return RowFilterExpression.fromEqualTo((EqualToExpression)builder.build());
    }

    public static RowFilterExpression fromGreaterThan(GreaterThanExpression greaterThan) {
        return (RowFilterExpression)RowFilterExpression.builder().greaterThan(greaterThan).build();
    }

    public static RowFilterExpression fromGreaterThan(Consumer<GreaterThanExpression.Builder> greaterThan) {
        GreaterThanExpression.Builder builder = GreaterThanExpression.builder();
        greaterThan.accept(builder);
        return RowFilterExpression.fromGreaterThan((GreaterThanExpression)builder.build());
    }

    public static RowFilterExpression fromGreaterThanOrEqualTo(GreaterThanOrEqualToExpression greaterThanOrEqualTo) {
        return (RowFilterExpression)RowFilterExpression.builder().greaterThanOrEqualTo(greaterThanOrEqualTo).build();
    }

    public static RowFilterExpression fromGreaterThanOrEqualTo(Consumer<GreaterThanOrEqualToExpression.Builder> greaterThanOrEqualTo) {
        GreaterThanOrEqualToExpression.Builder builder = GreaterThanOrEqualToExpression.builder();
        greaterThanOrEqualTo.accept(builder);
        return RowFilterExpression.fromGreaterThanOrEqualTo((GreaterThanOrEqualToExpression)builder.build());
    }

    public static RowFilterExpression fromIn(InExpression in) {
        return (RowFilterExpression)RowFilterExpression.builder().in(in).build();
    }

    public static RowFilterExpression fromIn(Consumer<InExpression.Builder> in) {
        InExpression.Builder builder = InExpression.builder();
        in.accept(builder);
        return RowFilterExpression.fromIn((InExpression)builder.build());
    }

    public static RowFilterExpression fromIsNotNull(IsNotNullExpression isNotNull) {
        return (RowFilterExpression)RowFilterExpression.builder().isNotNull(isNotNull).build();
    }

    public static RowFilterExpression fromIsNotNull(Consumer<IsNotNullExpression.Builder> isNotNull) {
        IsNotNullExpression.Builder builder = IsNotNullExpression.builder();
        isNotNull.accept(builder);
        return RowFilterExpression.fromIsNotNull((IsNotNullExpression)builder.build());
    }

    public static RowFilterExpression fromIsNull(IsNullExpression isNull) {
        return (RowFilterExpression)RowFilterExpression.builder().isNull(isNull).build();
    }

    public static RowFilterExpression fromIsNull(Consumer<IsNullExpression.Builder> isNull) {
        IsNullExpression.Builder builder = IsNullExpression.builder();
        isNull.accept(builder);
        return RowFilterExpression.fromIsNull((IsNullExpression)builder.build());
    }

    public static RowFilterExpression fromLessThan(LessThanExpression lessThan) {
        return (RowFilterExpression)RowFilterExpression.builder().lessThan(lessThan).build();
    }

    public static RowFilterExpression fromLessThan(Consumer<LessThanExpression.Builder> lessThan) {
        LessThanExpression.Builder builder = LessThanExpression.builder();
        lessThan.accept(builder);
        return RowFilterExpression.fromLessThan((LessThanExpression)builder.build());
    }

    public static RowFilterExpression fromLessThanOrEqualTo(LessThanOrEqualToExpression lessThanOrEqualTo) {
        return (RowFilterExpression)RowFilterExpression.builder().lessThanOrEqualTo(lessThanOrEqualTo).build();
    }

    public static RowFilterExpression fromLessThanOrEqualTo(Consumer<LessThanOrEqualToExpression.Builder> lessThanOrEqualTo) {
        LessThanOrEqualToExpression.Builder builder = LessThanOrEqualToExpression.builder();
        lessThanOrEqualTo.accept(builder);
        return RowFilterExpression.fromLessThanOrEqualTo((LessThanOrEqualToExpression)builder.build());
    }

    public static RowFilterExpression fromLike(LikeExpression like) {
        return (RowFilterExpression)RowFilterExpression.builder().like(like).build();
    }

    public static RowFilterExpression fromLike(Consumer<LikeExpression.Builder> like) {
        LikeExpression.Builder builder = LikeExpression.builder();
        like.accept(builder);
        return RowFilterExpression.fromLike((LikeExpression)builder.build());
    }

    public static RowFilterExpression fromNotEqualTo(NotEqualToExpression notEqualTo) {
        return (RowFilterExpression)RowFilterExpression.builder().notEqualTo(notEqualTo).build();
    }

    public static RowFilterExpression fromNotEqualTo(Consumer<NotEqualToExpression.Builder> notEqualTo) {
        NotEqualToExpression.Builder builder = NotEqualToExpression.builder();
        notEqualTo.accept(builder);
        return RowFilterExpression.fromNotEqualTo((NotEqualToExpression)builder.build());
    }

    public static RowFilterExpression fromNotIn(NotInExpression notIn) {
        return (RowFilterExpression)RowFilterExpression.builder().notIn(notIn).build();
    }

    public static RowFilterExpression fromNotIn(Consumer<NotInExpression.Builder> notIn) {
        NotInExpression.Builder builder = NotInExpression.builder();
        notIn.accept(builder);
        return RowFilterExpression.fromNotIn((NotInExpression)builder.build());
    }

    public static RowFilterExpression fromNotLike(NotLikeExpression notLike) {
        return (RowFilterExpression)RowFilterExpression.builder().notLike(notLike).build();
    }

    public static RowFilterExpression fromNotLike(Consumer<NotLikeExpression.Builder> notLike) {
        NotLikeExpression.Builder builder = NotLikeExpression.builder();
        notLike.accept(builder);
        return RowFilterExpression.fromNotLike((NotLikeExpression)builder.build());
    }

    public Type type() {
        return this.type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<SdkPojo>> map = new HashMap<String, SdkField<SdkPojo>>();
        map.put("equalTo", EQUAL_TO_FIELD);
        map.put("greaterThan", GREATER_THAN_FIELD);
        map.put("greaterThanOrEqualTo", GREATER_THAN_OR_EQUAL_TO_FIELD);
        map.put("in", IN_FIELD);
        map.put("isNotNull", IS_NOT_NULL_FIELD);
        map.put("isNull", IS_NULL_FIELD);
        map.put("lessThan", LESS_THAN_FIELD);
        map.put("lessThanOrEqualTo", LESS_THAN_OR_EQUAL_TO_FIELD);
        map.put("like", LIKE_FIELD);
        map.put("notEqualTo", NOT_EQUAL_TO_FIELD);
        map.put("notIn", NOT_IN_FIELD);
        map.put("notLike", NOT_LIKE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RowFilterExpression, T> g) {
        return obj -> g.apply((RowFilterExpression)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EqualToExpression equalTo;
        private GreaterThanExpression greaterThan;
        private GreaterThanOrEqualToExpression greaterThanOrEqualTo;
        private InExpression in;
        private IsNotNullExpression isNotNull;
        private IsNullExpression isNull;
        private LessThanExpression lessThan;
        private LessThanOrEqualToExpression lessThanOrEqualTo;
        private LikeExpression like;
        private NotEqualToExpression notEqualTo;
        private NotInExpression notIn;
        private NotLikeExpression notLike;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RowFilterExpression model) {
            this.equalTo(model.equalTo);
            this.greaterThan(model.greaterThan);
            this.greaterThanOrEqualTo(model.greaterThanOrEqualTo);
            this.in(model.in);
            this.isNotNull(model.isNotNull);
            this.isNull(model.isNull);
            this.lessThan(model.lessThan);
            this.lessThanOrEqualTo(model.lessThanOrEqualTo);
            this.like(model.like);
            this.notEqualTo(model.notEqualTo);
            this.notIn(model.notIn);
            this.notLike(model.notLike);
        }

        public final EqualToExpression.Builder getEqualTo() {
            return this.equalTo != null ? this.equalTo.toBuilder() : null;
        }

        public final void setEqualTo(EqualToExpression.BuilderImpl equalTo) {
            EqualToExpression oldValue = this.equalTo;
            this.equalTo = equalTo != null ? equalTo.build() : null;
            this.handleUnionValueChange(Type.EQUAL_TO, oldValue, this.equalTo);
        }

        @Override
        public final Builder equalTo(EqualToExpression equalTo) {
            EqualToExpression oldValue = this.equalTo;
            this.equalTo = equalTo;
            this.handleUnionValueChange(Type.EQUAL_TO, oldValue, this.equalTo);
            return this;
        }

        public final GreaterThanExpression.Builder getGreaterThan() {
            return this.greaterThan != null ? this.greaterThan.toBuilder() : null;
        }

        public final void setGreaterThan(GreaterThanExpression.BuilderImpl greaterThan) {
            GreaterThanExpression oldValue = this.greaterThan;
            this.greaterThan = greaterThan != null ? greaterThan.build() : null;
            this.handleUnionValueChange(Type.GREATER_THAN, oldValue, this.greaterThan);
        }

        @Override
        public final Builder greaterThan(GreaterThanExpression greaterThan) {
            GreaterThanExpression oldValue = this.greaterThan;
            this.greaterThan = greaterThan;
            this.handleUnionValueChange(Type.GREATER_THAN, oldValue, this.greaterThan);
            return this;
        }

        public final GreaterThanOrEqualToExpression.Builder getGreaterThanOrEqualTo() {
            return this.greaterThanOrEqualTo != null ? this.greaterThanOrEqualTo.toBuilder() : null;
        }

        public final void setGreaterThanOrEqualTo(GreaterThanOrEqualToExpression.BuilderImpl greaterThanOrEqualTo) {
            GreaterThanOrEqualToExpression oldValue = this.greaterThanOrEqualTo;
            this.greaterThanOrEqualTo = greaterThanOrEqualTo != null ? greaterThanOrEqualTo.build() : null;
            this.handleUnionValueChange(Type.GREATER_THAN_OR_EQUAL_TO, oldValue, this.greaterThanOrEqualTo);
        }

        @Override
        public final Builder greaterThanOrEqualTo(GreaterThanOrEqualToExpression greaterThanOrEqualTo) {
            GreaterThanOrEqualToExpression oldValue = this.greaterThanOrEqualTo;
            this.greaterThanOrEqualTo = greaterThanOrEqualTo;
            this.handleUnionValueChange(Type.GREATER_THAN_OR_EQUAL_TO, oldValue, this.greaterThanOrEqualTo);
            return this;
        }

        public final InExpression.Builder getIn() {
            return this.in != null ? this.in.toBuilder() : null;
        }

        public final void setIn(InExpression.BuilderImpl in) {
            InExpression oldValue = this.in;
            this.in = in != null ? in.build() : null;
            this.handleUnionValueChange(Type.IN, oldValue, this.in);
        }

        @Override
        public final Builder in(InExpression in) {
            InExpression oldValue = this.in;
            this.in = in;
            this.handleUnionValueChange(Type.IN, oldValue, this.in);
            return this;
        }

        public final IsNotNullExpression.Builder getIsNotNull() {
            return this.isNotNull != null ? this.isNotNull.toBuilder() : null;
        }

        public final void setIsNotNull(IsNotNullExpression.BuilderImpl isNotNull) {
            IsNotNullExpression oldValue = this.isNotNull;
            this.isNotNull = isNotNull != null ? isNotNull.build() : null;
            this.handleUnionValueChange(Type.IS_NOT_NULL, oldValue, this.isNotNull);
        }

        @Override
        public final Builder isNotNull(IsNotNullExpression isNotNull) {
            IsNotNullExpression oldValue = this.isNotNull;
            this.isNotNull = isNotNull;
            this.handleUnionValueChange(Type.IS_NOT_NULL, oldValue, this.isNotNull);
            return this;
        }

        public final IsNullExpression.Builder getIsNull() {
            return this.isNull != null ? this.isNull.toBuilder() : null;
        }

        public final void setIsNull(IsNullExpression.BuilderImpl isNull) {
            IsNullExpression oldValue = this.isNull;
            this.isNull = isNull != null ? isNull.build() : null;
            this.handleUnionValueChange(Type.IS_NULL, oldValue, this.isNull);
        }

        @Override
        public final Builder isNull(IsNullExpression isNull) {
            IsNullExpression oldValue = this.isNull;
            this.isNull = isNull;
            this.handleUnionValueChange(Type.IS_NULL, oldValue, this.isNull);
            return this;
        }

        public final LessThanExpression.Builder getLessThan() {
            return this.lessThan != null ? this.lessThan.toBuilder() : null;
        }

        public final void setLessThan(LessThanExpression.BuilderImpl lessThan) {
            LessThanExpression oldValue = this.lessThan;
            this.lessThan = lessThan != null ? lessThan.build() : null;
            this.handleUnionValueChange(Type.LESS_THAN, oldValue, this.lessThan);
        }

        @Override
        public final Builder lessThan(LessThanExpression lessThan) {
            LessThanExpression oldValue = this.lessThan;
            this.lessThan = lessThan;
            this.handleUnionValueChange(Type.LESS_THAN, oldValue, this.lessThan);
            return this;
        }

        public final LessThanOrEqualToExpression.Builder getLessThanOrEqualTo() {
            return this.lessThanOrEqualTo != null ? this.lessThanOrEqualTo.toBuilder() : null;
        }

        public final void setLessThanOrEqualTo(LessThanOrEqualToExpression.BuilderImpl lessThanOrEqualTo) {
            LessThanOrEqualToExpression oldValue = this.lessThanOrEqualTo;
            this.lessThanOrEqualTo = lessThanOrEqualTo != null ? lessThanOrEqualTo.build() : null;
            this.handleUnionValueChange(Type.LESS_THAN_OR_EQUAL_TO, oldValue, this.lessThanOrEqualTo);
        }

        @Override
        public final Builder lessThanOrEqualTo(LessThanOrEqualToExpression lessThanOrEqualTo) {
            LessThanOrEqualToExpression oldValue = this.lessThanOrEqualTo;
            this.lessThanOrEqualTo = lessThanOrEqualTo;
            this.handleUnionValueChange(Type.LESS_THAN_OR_EQUAL_TO, oldValue, this.lessThanOrEqualTo);
            return this;
        }

        public final LikeExpression.Builder getLike() {
            return this.like != null ? this.like.toBuilder() : null;
        }

        public final void setLike(LikeExpression.BuilderImpl like) {
            LikeExpression oldValue = this.like;
            this.like = like != null ? like.build() : null;
            this.handleUnionValueChange(Type.LIKE, oldValue, this.like);
        }

        @Override
        public final Builder like(LikeExpression like) {
            LikeExpression oldValue = this.like;
            this.like = like;
            this.handleUnionValueChange(Type.LIKE, oldValue, this.like);
            return this;
        }

        public final NotEqualToExpression.Builder getNotEqualTo() {
            return this.notEqualTo != null ? this.notEqualTo.toBuilder() : null;
        }

        public final void setNotEqualTo(NotEqualToExpression.BuilderImpl notEqualTo) {
            NotEqualToExpression oldValue = this.notEqualTo;
            this.notEqualTo = notEqualTo != null ? notEqualTo.build() : null;
            this.handleUnionValueChange(Type.NOT_EQUAL_TO, oldValue, this.notEqualTo);
        }

        @Override
        public final Builder notEqualTo(NotEqualToExpression notEqualTo) {
            NotEqualToExpression oldValue = this.notEqualTo;
            this.notEqualTo = notEqualTo;
            this.handleUnionValueChange(Type.NOT_EQUAL_TO, oldValue, this.notEqualTo);
            return this;
        }

        public final NotInExpression.Builder getNotIn() {
            return this.notIn != null ? this.notIn.toBuilder() : null;
        }

        public final void setNotIn(NotInExpression.BuilderImpl notIn) {
            NotInExpression oldValue = this.notIn;
            this.notIn = notIn != null ? notIn.build() : null;
            this.handleUnionValueChange(Type.NOT_IN, oldValue, this.notIn);
        }

        @Override
        public final Builder notIn(NotInExpression notIn) {
            NotInExpression oldValue = this.notIn;
            this.notIn = notIn;
            this.handleUnionValueChange(Type.NOT_IN, oldValue, this.notIn);
            return this;
        }

        public final NotLikeExpression.Builder getNotLike() {
            return this.notLike != null ? this.notLike.toBuilder() : null;
        }

        public final void setNotLike(NotLikeExpression.BuilderImpl notLike) {
            NotLikeExpression oldValue = this.notLike;
            this.notLike = notLike != null ? notLike.build() : null;
            this.handleUnionValueChange(Type.NOT_LIKE, oldValue, this.notLike);
        }

        @Override
        public final Builder notLike(NotLikeExpression notLike) {
            NotLikeExpression oldValue = this.notLike;
            this.notLike = notLike;
            this.handleUnionValueChange(Type.NOT_LIKE, oldValue, this.notLike);
            return this;
        }

        @Override
        public RowFilterExpression build() {
            return new RowFilterExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static enum Type {
        EQUAL_TO,
        GREATER_THAN,
        GREATER_THAN_OR_EQUAL_TO,
        IN,
        IS_NOT_NULL,
        IS_NULL,
        LESS_THAN,
        LESS_THAN_OR_EQUAL_TO,
        LIKE,
        NOT_EQUAL_TO,
        NOT_IN,
        NOT_LIKE,
        UNKNOWN_TO_SDK_VERSION;

    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RowFilterExpression> {
        public Builder equalTo(EqualToExpression var1);

        default public Builder equalTo(Consumer<EqualToExpression.Builder> equalTo) {
            return this.equalTo((EqualToExpression)EqualToExpression.builder().applyMutation(equalTo).build());
        }

        public Builder greaterThan(GreaterThanExpression var1);

        default public Builder greaterThan(Consumer<GreaterThanExpression.Builder> greaterThan) {
            return this.greaterThan((GreaterThanExpression)GreaterThanExpression.builder().applyMutation(greaterThan).build());
        }

        public Builder greaterThanOrEqualTo(GreaterThanOrEqualToExpression var1);

        default public Builder greaterThanOrEqualTo(Consumer<GreaterThanOrEqualToExpression.Builder> greaterThanOrEqualTo) {
            return this.greaterThanOrEqualTo((GreaterThanOrEqualToExpression)GreaterThanOrEqualToExpression.builder().applyMutation(greaterThanOrEqualTo).build());
        }

        public Builder in(InExpression var1);

        default public Builder in(Consumer<InExpression.Builder> in) {
            return this.in((InExpression)InExpression.builder().applyMutation(in).build());
        }

        public Builder isNotNull(IsNotNullExpression var1);

        default public Builder isNotNull(Consumer<IsNotNullExpression.Builder> isNotNull) {
            return this.isNotNull((IsNotNullExpression)IsNotNullExpression.builder().applyMutation(isNotNull).build());
        }

        public Builder isNull(IsNullExpression var1);

        default public Builder isNull(Consumer<IsNullExpression.Builder> isNull) {
            return this.isNull((IsNullExpression)IsNullExpression.builder().applyMutation(isNull).build());
        }

        public Builder lessThan(LessThanExpression var1);

        default public Builder lessThan(Consumer<LessThanExpression.Builder> lessThan) {
            return this.lessThan((LessThanExpression)LessThanExpression.builder().applyMutation(lessThan).build());
        }

        public Builder lessThanOrEqualTo(LessThanOrEqualToExpression var1);

        default public Builder lessThanOrEqualTo(Consumer<LessThanOrEqualToExpression.Builder> lessThanOrEqualTo) {
            return this.lessThanOrEqualTo((LessThanOrEqualToExpression)LessThanOrEqualToExpression.builder().applyMutation(lessThanOrEqualTo).build());
        }

        public Builder like(LikeExpression var1);

        default public Builder like(Consumer<LikeExpression.Builder> like) {
            return this.like((LikeExpression)LikeExpression.builder().applyMutation(like).build());
        }

        public Builder notEqualTo(NotEqualToExpression var1);

        default public Builder notEqualTo(Consumer<NotEqualToExpression.Builder> notEqualTo) {
            return this.notEqualTo((NotEqualToExpression)NotEqualToExpression.builder().applyMutation(notEqualTo).build());
        }

        public Builder notIn(NotInExpression var1);

        default public Builder notIn(Consumer<NotInExpression.Builder> notIn) {
            return this.notIn((NotInExpression)NotInExpression.builder().applyMutation(notIn).build());
        }

        public Builder notLike(NotLikeExpression var1);

        default public Builder notLike(Consumer<NotLikeExpression.Builder> notLike) {
            return this.notLike((NotLikeExpression)NotLikeExpression.builder().applyMutation(notLike).build());
        }
    }
}

