/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.DataSourceRunSummary;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListDataSourceRunsResponse;

public class ListDataSourceRunsIterable
implements SdkIterable<ListDataSourceRunsResponse> {
    private final DataZoneClient client;
    private final ListDataSourceRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataSourceRunsIterable(DataZoneClient client, ListDataSourceRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataSourceRunsResponseFetcher();
    }

    @Override
    public Iterator<ListDataSourceRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataSourceRunSummary> items() {
        Function<ListDataSourceRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataSourceRunsResponseFetcher
    implements SyncPageFetcher<ListDataSourceRunsResponse> {
        private ListDataSourceRunsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListDataSourceRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListDataSourceRunsResponse nextPage(ListDataSourceRunsResponse previousPage) {
            if (previousPage == null) {
                return ListDataSourceRunsIterable.this.client.listDataSourceRuns(ListDataSourceRunsIterable.this.firstRequest);
            }
            return ListDataSourceRunsIterable.this.client.listDataSourceRuns((ListDataSourceRunsRequest)ListDataSourceRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

