/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.EnvironmentBlueprintSummary;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentBlueprintsResponse;

public class ListEnvironmentBlueprintsIterable
implements SdkIterable<ListEnvironmentBlueprintsResponse> {
    private final DataZoneClient client;
    private final ListEnvironmentBlueprintsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentBlueprintsIterable(DataZoneClient client, ListEnvironmentBlueprintsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnvironmentBlueprintsResponseFetcher();
    }

    @Override
    public Iterator<ListEnvironmentBlueprintsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EnvironmentBlueprintSummary> items() {
        Function<ListEnvironmentBlueprintsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentBlueprintsResponseFetcher
    implements SyncPageFetcher<ListEnvironmentBlueprintsResponse> {
        private ListEnvironmentBlueprintsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListEnvironmentBlueprintsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListEnvironmentBlueprintsResponse nextPage(ListEnvironmentBlueprintsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentBlueprintsIterable.this.client.listEnvironmentBlueprints(ListEnvironmentBlueprintsIterable.this.firstRequest);
            }
            return ListEnvironmentBlueprintsIterable.this.client.listEnvironmentBlueprints((ListEnvironmentBlueprintsRequest)ListEnvironmentBlueprintsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

