/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListPolicyGrantsRequest;
import software.amazon.awssdk.services.datazone.model.ListPolicyGrantsResponse;
import software.amazon.awssdk.services.datazone.model.PolicyGrantMember;

public class ListPolicyGrantsIterable
implements SdkIterable<ListPolicyGrantsResponse> {
    private final DataZoneClient client;
    private final ListPolicyGrantsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPolicyGrantsIterable(DataZoneClient client, ListPolicyGrantsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPolicyGrantsResponseFetcher();
    }

    @Override
    public Iterator<ListPolicyGrantsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PolicyGrantMember> grantList() {
        Function<ListPolicyGrantsResponse, Iterator> getIterator = response -> {
            if (response != null && response.grantList() != null) {
                return response.grantList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListPolicyGrantsResponseFetcher
    implements SyncPageFetcher<ListPolicyGrantsResponse> {
        private ListPolicyGrantsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListPolicyGrantsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListPolicyGrantsResponse nextPage(ListPolicyGrantsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyGrantsIterable.this.client.listPolicyGrants(ListPolicyGrantsIterable.this.firstRequest);
            }
            return ListPolicyGrantsIterable.this.client.listPolicyGrants((ListPolicyGrantsRequest)ListPolicyGrantsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

