/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionStatistics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionStatistics> {
    private static final SdkField<Long> AVERAGE_EXECUTION_TIME_MILLIS_FIELD = SdkField.builder(MarshallingType.LONG).memberName("AverageExecutionTimeMillis").getter(ExecutionStatistics.getter(ExecutionStatistics::averageExecutionTimeMillis)).setter(ExecutionStatistics.setter(Builder::averageExecutionTimeMillis)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AverageExecutionTimeMillis").build()).build();
    private static final SdkField<Long> DATA_SCANNED_BYTES_FIELD = SdkField.builder(MarshallingType.LONG).memberName("DataScannedBytes").getter(ExecutionStatistics.getter(ExecutionStatistics::dataScannedBytes)).setter(ExecutionStatistics.setter(Builder::dataScannedBytes)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataScannedBytes").build()).build();
    private static final SdkField<Long> WORK_UNITS_EXECUTED_COUNT_FIELD = SdkField.builder(MarshallingType.LONG).memberName("WorkUnitsExecutedCount").getter(ExecutionStatistics.getter(ExecutionStatistics::workUnitsExecutedCount)).setter(ExecutionStatistics.setter(Builder::workUnitsExecutedCount)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkUnitsExecutedCount").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVERAGE_EXECUTION_TIME_MILLIS_FIELD, DATA_SCANNED_BYTES_FIELD, WORK_UNITS_EXECUTED_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecutionStatistics.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long averageExecutionTimeMillis;
    private final Long dataScannedBytes;
    private final Long workUnitsExecutedCount;

    private ExecutionStatistics(BuilderImpl builder) {
        this.averageExecutionTimeMillis = builder.averageExecutionTimeMillis;
        this.dataScannedBytes = builder.dataScannedBytes;
        this.workUnitsExecutedCount = builder.workUnitsExecutedCount;
    }

    public final Long averageExecutionTimeMillis() {
        return this.averageExecutionTimeMillis;
    }

    public final Long dataScannedBytes() {
        return this.dataScannedBytes;
    }

    public final Long workUnitsExecutedCount() {
        return this.workUnitsExecutedCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.averageExecutionTimeMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataScannedBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.workUnitsExecutedCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionStatistics)) {
            return false;
        }
        ExecutionStatistics other = (ExecutionStatistics)obj;
        return Objects.equals(this.averageExecutionTimeMillis(), other.averageExecutionTimeMillis()) && Objects.equals(this.dataScannedBytes(), other.dataScannedBytes()) && Objects.equals(this.workUnitsExecutedCount(), other.workUnitsExecutedCount());
    }

    public final String toString() {
        return ToString.builder("ExecutionStatistics").add("AverageExecutionTimeMillis", this.averageExecutionTimeMillis()).add("DataScannedBytes", this.dataScannedBytes()).add("WorkUnitsExecutedCount", this.workUnitsExecutedCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AverageExecutionTimeMillis": {
                return Optional.ofNullable(clazz.cast(this.averageExecutionTimeMillis()));
            }
            case "DataScannedBytes": {
                return Optional.ofNullable(clazz.cast(this.dataScannedBytes()));
            }
            case "WorkUnitsExecutedCount": {
                return Optional.ofNullable(clazz.cast(this.workUnitsExecutedCount()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Long>> map = new HashMap<String, SdkField<Long>>();
        map.put("AverageExecutionTimeMillis", AVERAGE_EXECUTION_TIME_MILLIS_FIELD);
        map.put("DataScannedBytes", DATA_SCANNED_BYTES_FIELD);
        map.put("WorkUnitsExecutedCount", WORK_UNITS_EXECUTED_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionStatistics, T> g) {
        return obj -> g.apply((ExecutionStatistics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long averageExecutionTimeMillis;
        private Long dataScannedBytes;
        private Long workUnitsExecutedCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionStatistics model) {
            this.averageExecutionTimeMillis(model.averageExecutionTimeMillis);
            this.dataScannedBytes(model.dataScannedBytes);
            this.workUnitsExecutedCount(model.workUnitsExecutedCount);
        }

        public final Long getAverageExecutionTimeMillis() {
            return this.averageExecutionTimeMillis;
        }

        public final void setAverageExecutionTimeMillis(Long averageExecutionTimeMillis) {
            this.averageExecutionTimeMillis = averageExecutionTimeMillis;
        }

        @Override
        public final Builder averageExecutionTimeMillis(Long averageExecutionTimeMillis) {
            this.averageExecutionTimeMillis = averageExecutionTimeMillis;
            return this;
        }

        public final Long getDataScannedBytes() {
            return this.dataScannedBytes;
        }

        public final void setDataScannedBytes(Long dataScannedBytes) {
            this.dataScannedBytes = dataScannedBytes;
        }

        @Override
        public final Builder dataScannedBytes(Long dataScannedBytes) {
            this.dataScannedBytes = dataScannedBytes;
            return this;
        }

        public final Long getWorkUnitsExecutedCount() {
            return this.workUnitsExecutedCount;
        }

        public final void setWorkUnitsExecutedCount(Long workUnitsExecutedCount) {
            this.workUnitsExecutedCount = workUnitsExecutedCount;
        }

        @Override
        public final Builder workUnitsExecutedCount(Long workUnitsExecutedCount) {
            this.workUnitsExecutedCount = workUnitsExecutedCount;
            return this;
        }

        @Override
        public ExecutionStatistics build() {
            return new ExecutionStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionStatistics> {
        public Builder averageExecutionTimeMillis(Long var1);

        public Builder dataScannedBytes(Long var1);

        public Builder workUnitsExecutedCount(Long var1);
    }
}

