/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lakeformation.model.OptimizerType;
import software.amazon.awssdk.services.lakeformation.model.StorageOptimizerConfigCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StorageOptimizer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StorageOptimizer> {
    private static final SdkField<String> STORAGE_OPTIMIZER_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("StorageOptimizerType").getter(StorageOptimizer.getter(StorageOptimizer::storageOptimizerTypeAsString)).setter(StorageOptimizer.setter(Builder::storageOptimizerType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageOptimizerType").build()).build();
    private static final SdkField<Map<String, String>> CONFIG_FIELD = SdkField.builder(MarshallingType.MAP).memberName("Config").getter(StorageOptimizer.getter(StorageOptimizer::config)).setter(StorageOptimizer.setter(Builder::config)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder(MarshallingType.STRING).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build()).build()).build();
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ErrorMessage").getter(StorageOptimizer.getter(StorageOptimizer::errorMessage)).setter(StorageOptimizer.setter(Builder::errorMessage)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorMessage").build()).build();
    private static final SdkField<String> WARNINGS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("Warnings").getter(StorageOptimizer.getter(StorageOptimizer::warnings)).setter(StorageOptimizer.setter(Builder::warnings)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warnings").build()).build();
    private static final SdkField<String> LAST_RUN_DETAILS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("LastRunDetails").getter(StorageOptimizer.getter(StorageOptimizer::lastRunDetails)).setter(StorageOptimizer.setter(Builder::lastRunDetails)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRunDetails").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_OPTIMIZER_TYPE_FIELD, CONFIG_FIELD, ERROR_MESSAGE_FIELD, WARNINGS_FIELD, LAST_RUN_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StorageOptimizer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String storageOptimizerType;
    private final Map<String, String> config;
    private final String errorMessage;
    private final String warnings;
    private final String lastRunDetails;

    private StorageOptimizer(BuilderImpl builder) {
        this.storageOptimizerType = builder.storageOptimizerType;
        this.config = builder.config;
        this.errorMessage = builder.errorMessage;
        this.warnings = builder.warnings;
        this.lastRunDetails = builder.lastRunDetails;
    }

    public final OptimizerType storageOptimizerType() {
        return OptimizerType.fromValue(this.storageOptimizerType);
    }

    public final String storageOptimizerTypeAsString() {
        return this.storageOptimizerType;
    }

    public final boolean hasConfig() {
        return this.config != null && !(this.config instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> config() {
        return this.config;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String warnings() {
        return this.warnings;
    }

    public final String lastRunDetails() {
        return this.lastRunDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.storageOptimizerTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfig() ? this.config() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.warnings());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageOptimizer)) {
            return false;
        }
        StorageOptimizer other = (StorageOptimizer)obj;
        return Objects.equals(this.storageOptimizerTypeAsString(), other.storageOptimizerTypeAsString()) && this.hasConfig() == other.hasConfig() && Objects.equals(this.config(), other.config()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.warnings(), other.warnings()) && Objects.equals(this.lastRunDetails(), other.lastRunDetails());
    }

    public final String toString() {
        return ToString.builder("StorageOptimizer").add("StorageOptimizerType", this.storageOptimizerTypeAsString()).add("Config", this.hasConfig() ? this.config() : null).add("ErrorMessage", this.errorMessage()).add("Warnings", this.warnings()).add("LastRunDetails", this.lastRunDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StorageOptimizerType": {
                return Optional.ofNullable(clazz.cast(this.storageOptimizerTypeAsString()));
            }
            case "Config": {
                return Optional.ofNullable(clazz.cast(this.config()));
            }
            case "ErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "Warnings": {
                return Optional.ofNullable(clazz.cast(this.warnings()));
            }
            case "LastRunDetails": {
                return Optional.ofNullable(clazz.cast(this.lastRunDetails()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("StorageOptimizerType", STORAGE_OPTIMIZER_TYPE_FIELD);
        map.put("Config", CONFIG_FIELD);
        map.put("ErrorMessage", ERROR_MESSAGE_FIELD);
        map.put("Warnings", WARNINGS_FIELD);
        map.put("LastRunDetails", LAST_RUN_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageOptimizer, T> g) {
        return obj -> g.apply((StorageOptimizer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String storageOptimizerType;
        private Map<String, String> config = DefaultSdkAutoConstructMap.getInstance();
        private String errorMessage;
        private String warnings;
        private String lastRunDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageOptimizer model) {
            this.storageOptimizerType(model.storageOptimizerType);
            this.config(model.config);
            this.errorMessage(model.errorMessage);
            this.warnings(model.warnings);
            this.lastRunDetails(model.lastRunDetails);
        }

        public final String getStorageOptimizerType() {
            return this.storageOptimizerType;
        }

        public final void setStorageOptimizerType(String storageOptimizerType) {
            this.storageOptimizerType = storageOptimizerType;
        }

        @Override
        public final Builder storageOptimizerType(String storageOptimizerType) {
            this.storageOptimizerType = storageOptimizerType;
            return this;
        }

        @Override
        public final Builder storageOptimizerType(OptimizerType storageOptimizerType) {
            this.storageOptimizerType(storageOptimizerType == null ? null : storageOptimizerType.toString());
            return this;
        }

        public final Map<String, String> getConfig() {
            if (this.config instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.config;
        }

        public final void setConfig(Map<String, String> config) {
            this.config = StorageOptimizerConfigCopier.copy(config);
        }

        @Override
        public final Builder config(Map<String, String> config) {
            this.config = StorageOptimizerConfigCopier.copy(config);
            return this;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getWarnings() {
            return this.warnings;
        }

        public final void setWarnings(String warnings) {
            this.warnings = warnings;
        }

        @Override
        public final Builder warnings(String warnings) {
            this.warnings = warnings;
            return this;
        }

        public final String getLastRunDetails() {
            return this.lastRunDetails;
        }

        public final void setLastRunDetails(String lastRunDetails) {
            this.lastRunDetails = lastRunDetails;
        }

        @Override
        public final Builder lastRunDetails(String lastRunDetails) {
            this.lastRunDetails = lastRunDetails;
            return this;
        }

        @Override
        public StorageOptimizer build() {
            return new StorageOptimizer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StorageOptimizer> {
        public Builder storageOptimizerType(String var1);

        public Builder storageOptimizerType(OptimizerType var1);

        public Builder config(Map<String, String> var1);

        public Builder errorMessage(String var1);

        public Builder warnings(String var1);

        public Builder lastRunDetails(String var1);
    }
}

