/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lakeformation.model.DatabaseResource;
import software.amazon.awssdk.services.lakeformation.model.LFTagPair;
import software.amazon.awssdk.services.lakeformation.model.LFTagsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaggedDatabase
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaggedDatabase> {
    private static final SdkField<DatabaseResource> DATABASE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("Database").getter(TaggedDatabase.getter(TaggedDatabase::database)).setter(TaggedDatabase.setter(Builder::database)).constructor(DatabaseResource::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();
    private static final SdkField<List<LFTagPair>> LF_TAGS_FIELD = SdkField.builder(MarshallingType.LIST).memberName("LFTags").getter(TaggedDatabase.getter(TaggedDatabase::lfTags)).setter(TaggedDatabase.setter(Builder::lfTags)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LFTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(LFTagPair::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATABASE_FIELD, LF_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaggedDatabase.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final DatabaseResource database;
    private final List<LFTagPair> lfTags;

    private TaggedDatabase(BuilderImpl builder) {
        this.database = builder.database;
        this.lfTags = builder.lfTags;
    }

    public final DatabaseResource database() {
        return this.database;
    }

    public final boolean hasLfTags() {
        return this.lfTags != null && !(this.lfTags instanceof SdkAutoConstructList);
    }

    public final List<LFTagPair> lfTags() {
        return this.lfTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLfTags() ? this.lfTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaggedDatabase)) {
            return false;
        }
        TaggedDatabase other = (TaggedDatabase)obj;
        return Objects.equals(this.database(), other.database()) && this.hasLfTags() == other.hasLfTags() && Objects.equals(this.lfTags(), other.lfTags());
    }

    public final String toString() {
        return ToString.builder("TaggedDatabase").add("Database", this.database()).add("LFTags", this.hasLfTags() ? this.lfTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "LFTags": {
                return Optional.ofNullable(clazz.cast(this.lfTags()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("Database", DATABASE_FIELD);
        map.put("LFTags", LF_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaggedDatabase, T> g) {
        return obj -> g.apply((TaggedDatabase)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DatabaseResource database;
        private List<LFTagPair> lfTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaggedDatabase model) {
            this.database(model.database);
            this.lfTags(model.lfTags);
        }

        public final DatabaseResource.Builder getDatabase() {
            return this.database != null ? this.database.toBuilder() : null;
        }

        public final void setDatabase(DatabaseResource.BuilderImpl database) {
            this.database = database != null ? database.build() : null;
        }

        @Override
        public final Builder database(DatabaseResource database) {
            this.database = database;
            return this;
        }

        public final List<LFTagPair.Builder> getLfTags() {
            List<LFTagPair.Builder> result = LFTagsListCopier.copyToBuilder(this.lfTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLfTags(Collection<LFTagPair.BuilderImpl> lfTags) {
            this.lfTags = LFTagsListCopier.copyFromBuilder(lfTags);
        }

        @Override
        public final Builder lfTags(Collection<LFTagPair> lfTags) {
            this.lfTags = LFTagsListCopier.copy(lfTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lfTags(LFTagPair ... lfTags) {
            this.lfTags(Arrays.asList(lfTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lfTags(Consumer<LFTagPair.Builder> ... lfTags) {
            this.lfTags(Stream.of(lfTags).map(c -> (LFTagPair)((LFTagPair.Builder)LFTagPair.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public TaggedDatabase build() {
            return new TaggedDatabase(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaggedDatabase> {
        public Builder database(DatabaseResource var1);

        default public Builder database(Consumer<DatabaseResource.Builder> database) {
            return this.database((DatabaseResource)DatabaseResource.builder().applyMutation(database).build());
        }

        public Builder lfTags(Collection<LFTagPair> var1);

        public Builder lfTags(LFTagPair ... var1);

        public Builder lfTags(Consumer<LFTagPair.Builder> ... var1);
    }
}

