/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.lakeformation.model.TransactionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransactionDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransactionDescription> {
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("TransactionId").getter(TransactionDescription.getter(TransactionDescription::transactionId)).setter(TransactionDescription.setter(Builder::transactionId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionId").build()).build();
    private static final SdkField<String> TRANSACTION_STATUS_FIELD = SdkField.builder(MarshallingType.STRING).memberName("TransactionStatus").getter(TransactionDescription.getter(TransactionDescription::transactionStatusAsString)).setter(TransactionDescription.setter(Builder::transactionStatus)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionStatus").build()).build();
    private static final SdkField<Instant> TRANSACTION_START_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("TransactionStartTime").getter(TransactionDescription.getter(TransactionDescription::transactionStartTime)).setter(TransactionDescription.setter(Builder::transactionStartTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionStartTime").build()).build();
    private static final SdkField<Instant> TRANSACTION_END_TIME_FIELD = SdkField.builder(MarshallingType.INSTANT).memberName("TransactionEndTime").getter(TransactionDescription.getter(TransactionDescription::transactionEndTime)).setter(TransactionDescription.setter(Builder::transactionEndTime)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransactionEndTime").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_ID_FIELD, TRANSACTION_STATUS_FIELD, TRANSACTION_START_TIME_FIELD, TRANSACTION_END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TransactionDescription.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String transactionId;
    private final String transactionStatus;
    private final Instant transactionStartTime;
    private final Instant transactionEndTime;

    private TransactionDescription(BuilderImpl builder) {
        this.transactionId = builder.transactionId;
        this.transactionStatus = builder.transactionStatus;
        this.transactionStartTime = builder.transactionStartTime;
        this.transactionEndTime = builder.transactionEndTime;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final TransactionStatus transactionStatus() {
        return TransactionStatus.fromValue(this.transactionStatus);
    }

    public final String transactionStatusAsString() {
        return this.transactionStatus;
    }

    public final Instant transactionStartTime() {
        return this.transactionStartTime;
    }

    public final Instant transactionEndTime() {
        return this.transactionEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionEndTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionDescription)) {
            return false;
        }
        TransactionDescription other = (TransactionDescription)obj;
        return Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.transactionStatusAsString(), other.transactionStatusAsString()) && Objects.equals(this.transactionStartTime(), other.transactionStartTime()) && Objects.equals(this.transactionEndTime(), other.transactionEndTime());
    }

    public final String toString() {
        return ToString.builder("TransactionDescription").add("TransactionId", this.transactionId()).add("TransactionStatus", this.transactionStatusAsString()).add("TransactionStartTime", this.transactionStartTime()).add("TransactionEndTime", this.transactionEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "TransactionStatus": {
                return Optional.ofNullable(clazz.cast(this.transactionStatusAsString()));
            }
            case "TransactionStartTime": {
                return Optional.ofNullable(clazz.cast(this.transactionStartTime()));
            }
            case "TransactionEndTime": {
                return Optional.ofNullable(clazz.cast(this.transactionEndTime()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("TransactionId", TRANSACTION_ID_FIELD);
        map.put("TransactionStatus", TRANSACTION_STATUS_FIELD);
        map.put("TransactionStartTime", TRANSACTION_START_TIME_FIELD);
        map.put("TransactionEndTime", TRANSACTION_END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransactionDescription, T> g) {
        return obj -> g.apply((TransactionDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transactionId;
        private String transactionStatus;
        private Instant transactionStartTime;
        private Instant transactionEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TransactionDescription model) {
            this.transactionId(model.transactionId);
            this.transactionStatus(model.transactionStatus);
            this.transactionStartTime(model.transactionStartTime);
            this.transactionEndTime(model.transactionEndTime);
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final String getTransactionStatus() {
            return this.transactionStatus;
        }

        public final void setTransactionStatus(String transactionStatus) {
            this.transactionStatus = transactionStatus;
        }

        @Override
        public final Builder transactionStatus(String transactionStatus) {
            this.transactionStatus = transactionStatus;
            return this;
        }

        @Override
        public final Builder transactionStatus(TransactionStatus transactionStatus) {
            this.transactionStatus(transactionStatus == null ? null : transactionStatus.toString());
            return this;
        }

        public final Instant getTransactionStartTime() {
            return this.transactionStartTime;
        }

        public final void setTransactionStartTime(Instant transactionStartTime) {
            this.transactionStartTime = transactionStartTime;
        }

        @Override
        public final Builder transactionStartTime(Instant transactionStartTime) {
            this.transactionStartTime = transactionStartTime;
            return this;
        }

        public final Instant getTransactionEndTime() {
            return this.transactionEndTime;
        }

        public final void setTransactionEndTime(Instant transactionEndTime) {
            this.transactionEndTime = transactionEndTime;
        }

        @Override
        public final Builder transactionEndTime(Instant transactionEndTime) {
            this.transactionEndTime = transactionEndTime;
            return this;
        }

        @Override
        public TransactionDescription build() {
            return new TransactionDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransactionDescription> {
        public Builder transactionId(String var1);

        public Builder transactionStatus(String var1);

        public Builder transactionStatus(TransactionStatus var1);

        public Builder transactionStartTime(Instant var1);

        public Builder transactionEndTime(Instant var1);
    }
}

