/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsRequest;
import software.amazon.awssdk.services.lakeformation.model.GetTableObjectsResponse;

public class GetTableObjectsPublisher
implements SdkPublisher<GetTableObjectsResponse> {
    private final LakeFormationAsyncClient client;
    private final GetTableObjectsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetTableObjectsPublisher(LakeFormationAsyncClient client, GetTableObjectsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetTableObjectsPublisher(LakeFormationAsyncClient client, GetTableObjectsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetTableObjectsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super GetTableObjectsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetTableObjectsResponseFetcher
    implements AsyncPageFetcher<GetTableObjectsResponse> {
        private GetTableObjectsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(GetTableObjectsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<GetTableObjectsResponse> nextPage(GetTableObjectsResponse previousPage) {
            if (previousPage == null) {
                return GetTableObjectsPublisher.this.client.getTableObjects(GetTableObjectsPublisher.this.firstRequest);
            }
            return GetTableObjectsPublisher.this.client.getTableObjects((GetTableObjectsRequest)GetTableObjectsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

