/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.ListLakeFormationOptInsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListLakeFormationOptInsResponse;

public class ListLakeFormationOptInsIterable
implements SdkIterable<ListLakeFormationOptInsResponse> {
    private final LakeFormationClient client;
    private final ListLakeFormationOptInsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLakeFormationOptInsIterable(LakeFormationClient client, ListLakeFormationOptInsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLakeFormationOptInsResponseFetcher();
    }

    @Override
    public Iterator<ListLakeFormationOptInsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListLakeFormationOptInsResponseFetcher
    implements SyncPageFetcher<ListLakeFormationOptInsResponse> {
        private ListLakeFormationOptInsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListLakeFormationOptInsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListLakeFormationOptInsResponse nextPage(ListLakeFormationOptInsResponse previousPage) {
            if (previousPage == null) {
                return ListLakeFormationOptInsIterable.this.client.listLakeFormationOptIns(ListLakeFormationOptInsIterable.this.firstRequest);
            }
            return ListLakeFormationOptInsIterable.this.client.listLakeFormationOptIns((ListLakeFormationOptInsRequest)ListLakeFormationOptInsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

