/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lakeformation.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lakeformation.LakeFormationAsyncClient;
import software.amazon.awssdk.services.lakeformation.internal.UserAgentUtils;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsRequest;
import software.amazon.awssdk.services.lakeformation.model.ListPermissionsResponse;

public class ListPermissionsPublisher
implements SdkPublisher<ListPermissionsResponse> {
    private final LakeFormationAsyncClient client;
    private final ListPermissionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPermissionsPublisher(LakeFormationAsyncClient client, ListPermissionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPermissionsPublisher(LakeFormationAsyncClient client, ListPermissionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPermissionsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListPermissionsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPermissionsResponseFetcher
    implements AsyncPageFetcher<ListPermissionsResponse> {
        private ListPermissionsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListPermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListPermissionsResponse> nextPage(ListPermissionsResponse previousPage) {
            if (previousPage == null) {
                return ListPermissionsPublisher.this.client.listPermissions(ListPermissionsPublisher.this.firstRequest);
            }
            return ListPermissionsPublisher.this.client.listPermissions((ListPermissionsRequest)ListPermissionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

