/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.utils.StringUtils;

@SdkInternalApi
public final class ObjectMetadataInterceptor
implements ExecutionInterceptor {
    @Override
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest request = context.request();
        switch (executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME)) {
            case "PutObject": {
                return this.trimMetadataNames((PutObjectRequest)request);
            }
            case "CreateMultipartUpload": {
                return this.trimMetadataNames((CreateMultipartUploadRequest)request);
            }
        }
        return request;
    }

    private PutObjectRequest trimMetadataNames(PutObjectRequest putObjectRequest) {
        if (!putObjectRequest.hasMetadata()) {
            return putObjectRequest;
        }
        return (PutObjectRequest)putObjectRequest.toBuilder().metadata(this.trimKeys(putObjectRequest.metadata())).build();
    }

    private CreateMultipartUploadRequest trimMetadataNames(CreateMultipartUploadRequest createMultipartUploadRequest) {
        if (!createMultipartUploadRequest.hasMetadata()) {
            return createMultipartUploadRequest;
        }
        return (CreateMultipartUploadRequest)createMultipartUploadRequest.toBuilder().metadata(this.trimKeys(createMultipartUploadRequest.metadata())).build();
    }

    private Map<String, String> trimKeys(Map<String, String> map) {
        return map.entrySet().stream().collect(HashMap::new, (m, e) -> m.put(StringUtils.trim((String)e.getKey()), (String)e.getValue()), HashMap::putAll);
    }
}

