/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;

@SdkInternalApi
public final class StreamingRequestInterceptor
implements ExecutionInterceptor {
    private static final String DECODED_CONTENT_LENGTH_HEADER = "x-amz-decoded-content-length";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";

    @Override
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        if (this.shouldAddExpectContinueHeader(context)) {
            return (SdkHttpRequest)((SdkHttpRequest.Builder)context.httpRequest().toBuilder()).putHeader("Expect", "100-continue").build();
        }
        return context.httpRequest();
    }

    private boolean shouldAddExpectContinueHeader(Context.ModifyHttpRequest context) {
        if (!(context.request() instanceof PutObjectRequest) && !(context.request() instanceof UploadPartRequest)) {
            return false;
        }
        return this.getContentLengthHeader(context.httpRequest()).map(Long::parseLong).map(length -> length != 0L).orElse(true);
    }

    private Optional<String> getContentLengthHeader(SdkHttpRequest httpRequest) {
        Optional<String> decodedLength = httpRequest.firstMatchingHeader(DECODED_CONTENT_LENGTH_HEADER);
        return decodedLength.isPresent() ? decodedLength : httpRequest.firstMatchingHeader(CONTENT_LENGTH_HEADER);
    }
}

