/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.handlers;

import java.io.InputStream;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.checksums.Md5Checksum;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.services.s3.internal.checksums.ChecksumsEnabledValidator;
import software.amazon.awssdk.services.s3.internal.checksums.S3ChecksumValidatingInputStream;

@SdkInternalApi
public final class SyncChecksumValidationInterceptor
implements ExecutionInterceptor {
    @Override
    public Optional<InputStream> modifyHttpResponseContent(Context.ModifyHttpResponse context, ExecutionAttributes executionAttributes) {
        if (ChecksumsEnabledValidator.getObjectChecksumEnabledPerResponse(context.request(), context.httpResponse(), executionAttributes) && context.responseBody().isPresent()) {
            Md5Checksum checksum = new Md5Checksum();
            long contentLength = context.httpResponse().firstMatchingHeader("Content-Length").map(Long::parseLong).orElse(0L);
            if (contentLength > 0L) {
                return Optional.of(new S3ChecksumValidatingInputStream(context.responseBody().get(), checksum, contentLength));
            }
        }
        return context.responseBody();
    }
}

