/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.plugins;

import java.util.ArrayList;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4FamilyHttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeParams;
import software.amazon.awssdk.services.s3.auth.scheme.S3AuthSchemeProvider;

@SdkInternalApi
public final class S3DisableChunkEncodingAuthSchemeProvider
implements S3AuthSchemeProvider {
    private final S3AuthSchemeProvider delegate;

    private S3DisableChunkEncodingAuthSchemeProvider(S3AuthSchemeProvider delegate) {
        this.delegate = delegate;
    }

    public static S3DisableChunkEncodingAuthSchemeProvider create(S3AuthSchemeProvider delegate) {
        return new S3DisableChunkEncodingAuthSchemeProvider(delegate);
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(S3AuthSchemeParams authSchemeParams) {
        List<AuthSchemeOption> options;
        List<AuthSchemeOption> result = options = this.delegate.resolveAuthScheme(authSchemeParams);
        String operation = authSchemeParams.operation();
        if ("PutObject".equals(operation) || "UploadPart".equals(operation)) {
            result = new ArrayList<AuthSchemeOption>(options.size());
            for (AuthSchemeOption option : options) {
                String schemeId = option.schemeId();
                if (!schemeId.startsWith("aws.auth#sigv4")) continue;
                result.add((AuthSchemeOption)((AuthSchemeOption.Builder)option.toBuilder()).putSignerProperty(AwsV4FamilyHttpSigner.CHUNK_ENCODING_ENABLED, false).build());
            }
        }
        return result;
    }
}

