/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.s3express;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4FamilyHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.AsyncSignRequest;
import software.amazon.awssdk.http.auth.spi.signer.AsyncSignedRequest;
import software.amazon.awssdk.http.auth.spi.signer.BaseSignRequest;
import software.amazon.awssdk.http.auth.spi.signer.HttpSigner;
import software.amazon.awssdk.http.auth.spi.signer.SignRequest;
import software.amazon.awssdk.http.auth.spi.signer.SignedRequest;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.services.s3.s3express.S3ExpressSessionCredentials;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultS3ExpressHttpSigner
implements HttpSigner<S3ExpressSessionCredentials> {
    private static final String SESSION_HEADER = "x-amz-s3session-token";
    private static final String SESSION_HEADER_PRESIGNING = "X-Amz-S3session-Token";
    private final HttpSigner<AwsCredentialsIdentity> signer;

    private DefaultS3ExpressHttpSigner(HttpSigner<AwsCredentialsIdentity> signer) {
        this.signer = Validate.notNull(signer, "signer", new Object[0]);
    }

    public static DefaultS3ExpressHttpSigner create(HttpSigner<AwsCredentialsIdentity> signer) {
        return new DefaultS3ExpressHttpSigner(signer);
    }

    public static DefaultS3ExpressHttpSigner create() {
        return new DefaultS3ExpressHttpSigner(AwsV4HttpSigner.create());
    }

    @Override
    public SignedRequest sign(SignRequest<? extends S3ExpressSessionCredentials> request) {
        SdkHttpRequest requestToSign = DefaultS3ExpressHttpSigner.withSessionHeader(request);
        SignRequest signRequest = (SignRequest)request.copy(b -> b.request(requestToSign));
        return this.signer.sign(signRequest);
    }

    @Override
    public CompletableFuture<AsyncSignedRequest> signAsync(AsyncSignRequest<? extends S3ExpressSessionCredentials> request) {
        SdkHttpRequest requestWithHeader = DefaultS3ExpressHttpSigner.withSessionHeader(request);
        return this.signer.signAsync((AsyncSignRequest)request.copy(b -> b.request(requestWithHeader)));
    }

    static SdkHttpRequest withSessionHeader(BaseSignRequest<?, ? extends S3ExpressSessionCredentials> request) {
        S3ExpressSessionCredentials identity = request.identity();
        Validate.notNull(identity, "request identity cannot be null", new Object[0]);
        if (request.property(AwsV4FamilyHttpSigner.AUTH_LOCATION) == AwsV4FamilyHttpSigner.AuthLocation.QUERY_STRING) {
            return (SdkHttpRequest)request.request().copy(b -> b.putRawQueryParameter(SESSION_HEADER_PRESIGNING, identity.sessionToken()));
        }
        return (SdkHttpRequest)request.request().copy(b -> b.putHeader(SESSION_HEADER, identity.sessionToken()));
    }
}

