/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.awscore.AwsResponseMetadata;
import software.amazon.awssdk.services.s3.model.S3ResponseMetadata;

public abstract class S3Response
extends AwsResponse {
    private final S3ResponseMetadata responseMetadata;

    protected S3Response(Builder builder) {
        super(builder);
        this.responseMetadata = builder.responseMetadata();
    }

    @Override
    public S3ResponseMetadata responseMetadata() {
        return this.responseMetadata;
    }

    public static interface Builder
    extends AwsResponse.Builder {
        @Override
        public S3Response build();

        @Override
        public S3ResponseMetadata responseMetadata();

        @Override
        public Builder responseMetadata(AwsResponseMetadata var1);
    }

    protected static abstract class BuilderImpl
    extends AwsResponse.BuilderImpl
    implements Builder {
        private S3ResponseMetadata responseMetadata;

        protected BuilderImpl() {
        }

        protected BuilderImpl(S3Response response) {
            super(response);
            this.responseMetadata = response.responseMetadata();
        }

        @Override
        public S3ResponseMetadata responseMetadata() {
            return this.responseMetadata;
        }

        @Override
        public Builder responseMetadata(AwsResponseMetadata responseMetadata) {
            this.responseMetadata = S3ResponseMetadata.create(responseMetadata);
            return this;
        }
    }
}

