/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.presigner.model;

import java.time.Duration;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.presigner.PresignRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@Immutable
@ThreadSafe
public final class PutObjectPresignRequest
extends PresignRequest
implements ToCopyableBuilder<Builder, PutObjectPresignRequest> {
    private final PutObjectRequest putObjectRequest;

    private PutObjectPresignRequest(DefaultBuilder builder) {
        super(builder);
        this.putObjectRequest = Validate.notNull(builder.putObjectRequest, "putObjectRequest", new Object[0]);
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    public PutObjectRequest putObjectRequest() {
        return this.putObjectRequest;
    }

    @Override
    public Builder toBuilder() {
        return new DefaultBuilder(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PutObjectPresignRequest that = (PutObjectPresignRequest)o;
        return this.putObjectRequest.equals(that.putObjectRequest);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.putObjectRequest.hashCode();
        return result;
    }

    @SdkInternalApi
    private static final class DefaultBuilder
    extends PresignRequest.DefaultBuilder<DefaultBuilder>
    implements Builder {
        private PutObjectRequest putObjectRequest;

        private DefaultBuilder() {
        }

        private DefaultBuilder(PutObjectPresignRequest request) {
            super(request);
            this.putObjectRequest = request.putObjectRequest;
        }

        @Override
        public Builder putObjectRequest(PutObjectRequest putObjectRequest) {
            this.putObjectRequest = putObjectRequest;
            return this;
        }

        @Override
        public PutObjectPresignRequest build() {
            return new PutObjectPresignRequest(this);
        }
    }

    @SdkPublicApi
    @NotThreadSafe
    public static interface Builder
    extends PresignRequest.Builder,
    CopyableBuilder<Builder, PutObjectPresignRequest> {
        public Builder putObjectRequest(PutObjectRequest var1);

        default public Builder putObjectRequest(Consumer<PutObjectRequest.Builder> putObjectRequest) {
            PutObjectRequest.Builder builder = PutObjectRequest.builder();
            putObjectRequest.accept(builder);
            return this.putObjectRequest((PutObjectRequest)builder.build());
        }

        @Override
        public Builder signatureDuration(Duration var1);

        @Override
        public PutObjectPresignRequest build();
    }
}

