/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sso.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sso.model.RoleInfo;
import software.amazon.awssdk.services.sso.model.RoleListTypeCopier;
import software.amazon.awssdk.services.sso.model.SsoResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAccountRolesResponse
extends SsoResponse
implements ToCopyableBuilder<Builder, ListAccountRolesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("nextToken").getter(ListAccountRolesResponse.getter(ListAccountRolesResponse::nextToken)).setter(ListAccountRolesResponse.setter(Builder::nextToken)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();
    private static final SdkField<List<RoleInfo>> ROLE_LIST_FIELD = SdkField.builder(MarshallingType.LIST).memberName("roleList").getter(ListAccountRolesResponse.getter(ListAccountRolesResponse::roleList)).setter(ListAccountRolesResponse.setter(Builder::roleList)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder(MarshallingType.SDK_POJO).constructor(RoleInfo::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()).build()).build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ROLE_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAccountRolesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<RoleInfo> roleList;

    private ListAccountRolesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.roleList = builder.roleList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRoleList() {
        return this.roleList != null && !(this.roleList instanceof SdkAutoConstructList);
    }

    public final List<RoleInfo> roleList() {
        return this.roleList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRoleList() ? this.roleList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAccountRolesResponse)) {
            return false;
        }
        ListAccountRolesResponse other = (ListAccountRolesResponse)obj;
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasRoleList() == other.hasRoleList() && Objects.equals(this.roleList(), other.roleList());
    }

    public final String toString() {
        return ToString.builder("ListAccountRolesResponse").add("NextToken", this.nextToken()).add("RoleList", this.hasRoleList() ? this.roleList() : null).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "roleList": {
                return Optional.ofNullable(clazz.cast(this.roleList()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Object>> map = new HashMap<String, SdkField<Object>>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("roleList", ROLE_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAccountRolesResponse, T> g) {
        return obj -> g.apply((ListAccountRolesResponse)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<RoleInfo> roleList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAccountRolesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.roleList(model.roleList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<RoleInfo.Builder> getRoleList() {
            List<RoleInfo.Builder> result = RoleListTypeCopier.copyToBuilder(this.roleList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoleList(Collection<RoleInfo.BuilderImpl> roleList) {
            this.roleList = RoleListTypeCopier.copyFromBuilder(roleList);
        }

        @Override
        public final Builder roleList(Collection<RoleInfo> roleList) {
            this.roleList = RoleListTypeCopier.copy(roleList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleList(RoleInfo ... roleList) {
            this.roleList(Arrays.asList(roleList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleList(Consumer<RoleInfo.Builder> ... roleList) {
            this.roleList(Stream.of(roleList).map(c -> (RoleInfo)((RoleInfo.Builder)RoleInfo.builder().applyMutation(c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListAccountRolesResponse build() {
            return new ListAccountRolesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAccountRolesResponse> {
        public Builder nextToken(String var1);

        public Builder roleList(Collection<RoleInfo> var1);

        public Builder roleList(RoleInfo ... var1);

        public Builder roleList(Consumer<RoleInfo.Builder> ... var1);
    }
}

