/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.SsoAdminServiceClientConfiguration;
import software.amazon.awssdk.services.ssoadmin.internal.SsoAdminServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ssoadmin.model.AccessDeniedException;
import software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.AttachCustomerManagedPolicyReferenceToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.AttachManagedPolicyToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ConflictException;
import software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateAccountAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateApplicationAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateApplicationAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateApplicationRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateApplicationResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateInstanceResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreatePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.CreateTrustedTokenIssuerRequest;
import software.amazon.awssdk.services.ssoadmin.model.CreateTrustedTokenIssuerResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteAccountAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAccessScopeRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAccessScopeResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAuthenticationMethodRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationAuthenticationMethodResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationGrantRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationGrantResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInlinePolicyFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteInstanceResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeletePermissionsBoundaryFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DeleteTrustedTokenIssuerRequest;
import software.amazon.awssdk.services.ssoadmin.model.DeleteTrustedTokenIssuerResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentCreationStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeAccountAssignmentDeletionStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationAssignmentRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationAssignmentResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationProviderRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationProviderResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeApplicationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeInstanceResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DescribeTrustedTokenIssuerRequest;
import software.amazon.awssdk.services.ssoadmin.model.DescribeTrustedTokenIssuerResponse;
import software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DetachCustomerManagedPolicyReferenceFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.DetachManagedPolicyFromPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationAccessScopeRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationAccessScopeResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationAssignmentConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationAssignmentConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationAuthenticationMethodRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationAuthenticationMethodResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationGrantRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationGrantResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationSessionConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetApplicationSessionConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetInlinePolicyForPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.GetPermissionsBoundaryForPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.InternalServerException;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentCreationStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentDeletionStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsForPrincipalResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountAssignmentsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListAccountsForProvisionedPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsForPrincipalResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAssignmentsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationGrantsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationProvidersResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListCustomerManagedPolicyReferencesInPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListInstancesResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListManagedPoliciesInPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetProvisioningStatusResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsProvisionedToAccountResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListPermissionSetsResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListTrustedTokenIssuersResponse;
import software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.ProvisionPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationAccessScopeRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationAccessScopeResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationAssignmentConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationAssignmentConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationAuthenticationMethodRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationAuthenticationMethodResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationGrantRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationGrantResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationSessionConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutApplicationSessionConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutInlinePolicyToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.PutPermissionsBoundaryToPermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.ResourceNotFoundException;
import software.amazon.awssdk.services.ssoadmin.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminException;
import software.amazon.awssdk.services.ssoadmin.model.TagResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.TagResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.ThrottlingException;
import software.amazon.awssdk.services.ssoadmin.model.UntagResourceRequest;
import software.amazon.awssdk.services.ssoadmin.model.UntagResourceResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceAccessControlAttributeConfigurationResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdateInstanceResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdatePermissionSetResponse;
import software.amazon.awssdk.services.ssoadmin.model.UpdateTrustedTokenIssuerRequest;
import software.amazon.awssdk.services.ssoadmin.model.UpdateTrustedTokenIssuerResponse;
import software.amazon.awssdk.services.ssoadmin.model.ValidationException;
import software.amazon.awssdk.services.ssoadmin.transform.AttachCustomerManagedPolicyReferenceToPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.AttachManagedPolicyToPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.CreateAccountAssignmentRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.CreateApplicationAssignmentRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.CreateApplicationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.CreateInstanceAccessControlAttributeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.CreateInstanceRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.CreatePermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.CreateTrustedTokenIssuerRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteAccountAssignmentRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteApplicationAccessScopeRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteApplicationAssignmentRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteApplicationAuthenticationMethodRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteApplicationGrantRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteApplicationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteInlinePolicyFromPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteInstanceAccessControlAttributeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteInstanceRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeletePermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeletePermissionsBoundaryFromPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DeleteTrustedTokenIssuerRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeAccountAssignmentCreationStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeAccountAssignmentDeletionStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeApplicationAssignmentRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeApplicationProviderRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeApplicationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeInstanceAccessControlAttributeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeInstanceRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribePermissionSetProvisioningStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribePermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DescribeTrustedTokenIssuerRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DetachCustomerManagedPolicyReferenceFromPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.DetachManagedPolicyFromPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.GetApplicationAccessScopeRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.GetApplicationAssignmentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.GetApplicationAuthenticationMethodRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.GetApplicationGrantRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.GetApplicationSessionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.GetInlinePolicyForPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.GetPermissionsBoundaryForPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListAccountAssignmentCreationStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListAccountAssignmentDeletionStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListAccountAssignmentsForPrincipalRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListAccountAssignmentsRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListAccountsForProvisionedPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListApplicationAccessScopesRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListApplicationAssignmentsForPrincipalRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListApplicationAssignmentsRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListApplicationAuthenticationMethodsRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListApplicationGrantsRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListApplicationProvidersRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListApplicationsRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListCustomerManagedPolicyReferencesInPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListInstancesRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListManagedPoliciesInPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListPermissionSetProvisioningStatusRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListPermissionSetsProvisionedToAccountRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListPermissionSetsRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ListTrustedTokenIssuersRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.ProvisionPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.PutApplicationAccessScopeRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.PutApplicationAssignmentConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.PutApplicationAuthenticationMethodRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.PutApplicationGrantRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.PutApplicationSessionConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.PutInlinePolicyToPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.PutPermissionsBoundaryToPermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.UpdateApplicationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.UpdateInstanceAccessControlAttributeConfigurationRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.UpdateInstanceRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.UpdatePermissionSetRequestMarshaller;
import software.amazon.awssdk.services.ssoadmin.transform.UpdateTrustedTokenIssuerRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultSsoAdminClient
implements SsoAdminClient {
    private static final Logger log = Logger.loggerFor(DefaultSsoAdminClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSsoAdminClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).option(SdkClientOption.API_METADATA, "SSO_Admin#2.38.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachCustomerManagedPolicyReferenceToPermissionSetResponse attachCustomerManagedPolicyReferenceToPermissionSet(AttachCustomerManagedPolicyReferenceToPermissionSetRequest attachCustomerManagedPolicyReferenceToPermissionSetRequest) throws ServiceQuotaExceededException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachCustomerManagedPolicyReferenceToPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(attachCustomerManagedPolicyReferenceToPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, attachCustomerManagedPolicyReferenceToPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachCustomerManagedPolicyReferenceToPermissionSet");
            AttachCustomerManagedPolicyReferenceToPermissionSetResponse attachCustomerManagedPolicyReferenceToPermissionSetResponse = (AttachCustomerManagedPolicyReferenceToPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachCustomerManagedPolicyReferenceToPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(attachCustomerManagedPolicyReferenceToPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new AttachCustomerManagedPolicyReferenceToPermissionSetRequestMarshaller(this.protocolFactory)));
            return attachCustomerManagedPolicyReferenceToPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AttachManagedPolicyToPermissionSetResponse attachManagedPolicyToPermissionSet(AttachManagedPolicyToPermissionSetRequest attachManagedPolicyToPermissionSetRequest) throws ServiceQuotaExceededException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AttachManagedPolicyToPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(attachManagedPolicyToPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, attachManagedPolicyToPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachManagedPolicyToPermissionSet");
            AttachManagedPolicyToPermissionSetResponse attachManagedPolicyToPermissionSetResponse = (AttachManagedPolicyToPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AttachManagedPolicyToPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(attachManagedPolicyToPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new AttachManagedPolicyToPermissionSetRequestMarshaller(this.protocolFactory)));
            return attachManagedPolicyToPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAccountAssignmentResponse createAccountAssignment(CreateAccountAssignmentRequest createAccountAssignmentRequest) throws ServiceQuotaExceededException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAccountAssignmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createAccountAssignmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, createAccountAssignmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountAssignment");
            CreateAccountAssignmentResponse createAccountAssignmentResponse = (CreateAccountAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAccountAssignment").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createAccountAssignmentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateAccountAssignmentRequestMarshaller(this.protocolFactory)));
            return createAccountAssignmentResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest) throws ServiceQuotaExceededException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, createApplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApplication");
            CreateApplicationResponse createApplicationResponse = (CreateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplication").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createApplicationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateApplicationRequestMarshaller(this.protocolFactory)));
            return createApplicationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateApplicationAssignmentResponse createApplicationAssignment(CreateApplicationAssignmentRequest createApplicationAssignmentRequest) throws ServiceQuotaExceededException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateApplicationAssignmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createApplicationAssignmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, createApplicationAssignmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApplicationAssignment");
            CreateApplicationAssignmentResponse createApplicationAssignmentResponse = (CreateApplicationAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateApplicationAssignment").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createApplicationAssignmentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateApplicationAssignmentRequestMarshaller(this.protocolFactory)));
            return createApplicationAssignmentResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInstanceResponse createInstance(CreateInstanceRequest createInstanceRequest) throws ServiceQuotaExceededException, ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, createInstanceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstance");
            CreateInstanceResponse createInstanceResponse = (CreateInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInstance").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createInstanceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateInstanceRequestMarshaller(this.protocolFactory)));
            return createInstanceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateInstanceAccessControlAttributeConfigurationResponse createInstanceAccessControlAttributeConfiguration(CreateInstanceAccessControlAttributeConfigurationRequest createInstanceAccessControlAttributeConfigurationRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateInstanceAccessControlAttributeConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createInstanceAccessControlAttributeConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, createInstanceAccessControlAttributeConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceAccessControlAttributeConfiguration");
            CreateInstanceAccessControlAttributeConfigurationResponse createInstanceAccessControlAttributeConfigurationResponse = (CreateInstanceAccessControlAttributeConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateInstanceAccessControlAttributeConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createInstanceAccessControlAttributeConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateInstanceAccessControlAttributeConfigurationRequestMarshaller(this.protocolFactory)));
            return createInstanceAccessControlAttributeConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreatePermissionSetResponse createPermissionSet(CreatePermissionSetRequest createPermissionSetRequest) throws ServiceQuotaExceededException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreatePermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, createPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePermissionSet");
            CreatePermissionSetResponse createPermissionSetResponse = (CreatePermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreatePermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreatePermissionSetRequestMarshaller(this.protocolFactory)));
            return createPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrustedTokenIssuerResponse createTrustedTokenIssuer(CreateTrustedTokenIssuerRequest createTrustedTokenIssuerRequest) throws ServiceQuotaExceededException, ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTrustedTokenIssuerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(createTrustedTokenIssuerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, createTrustedTokenIssuerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTrustedTokenIssuer");
            CreateTrustedTokenIssuerResponse createTrustedTokenIssuerResponse = (CreateTrustedTokenIssuerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrustedTokenIssuer").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(createTrustedTokenIssuerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new CreateTrustedTokenIssuerRequestMarshaller(this.protocolFactory)));
            return createTrustedTokenIssuerResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAccountAssignmentResponse deleteAccountAssignment(DeleteAccountAssignmentRequest deleteAccountAssignmentRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAccountAssignmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteAccountAssignmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, deleteAccountAssignmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountAssignment");
            DeleteAccountAssignmentResponse deleteAccountAssignmentResponse = (DeleteAccountAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAccountAssignment").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteAccountAssignmentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteAccountAssignmentRequestMarshaller(this.protocolFactory)));
            return deleteAccountAssignmentResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, deleteApplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApplication");
            DeleteApplicationResponse deleteApplicationResponse = (DeleteApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplication").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteApplicationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteApplicationRequestMarshaller(this.protocolFactory)));
            return deleteApplicationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationAccessScopeResponse deleteApplicationAccessScope(DeleteApplicationAccessScopeRequest deleteApplicationAccessScopeRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationAccessScopeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteApplicationAccessScopeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, deleteApplicationAccessScopeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApplicationAccessScope");
            DeleteApplicationAccessScopeResponse deleteApplicationAccessScopeResponse = (DeleteApplicationAccessScopeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationAccessScope").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteApplicationAccessScopeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteApplicationAccessScopeRequestMarshaller(this.protocolFactory)));
            return deleteApplicationAccessScopeResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationAssignmentResponse deleteApplicationAssignment(DeleteApplicationAssignmentRequest deleteApplicationAssignmentRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationAssignmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteApplicationAssignmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, deleteApplicationAssignmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApplicationAssignment");
            DeleteApplicationAssignmentResponse deleteApplicationAssignmentResponse = (DeleteApplicationAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationAssignment").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteApplicationAssignmentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteApplicationAssignmentRequestMarshaller(this.protocolFactory)));
            return deleteApplicationAssignmentResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationAuthenticationMethodResponse deleteApplicationAuthenticationMethod(DeleteApplicationAuthenticationMethodRequest deleteApplicationAuthenticationMethodRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationAuthenticationMethodResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteApplicationAuthenticationMethodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, deleteApplicationAuthenticationMethodRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApplicationAuthenticationMethod");
            DeleteApplicationAuthenticationMethodResponse deleteApplicationAuthenticationMethodResponse = (DeleteApplicationAuthenticationMethodResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationAuthenticationMethod").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteApplicationAuthenticationMethodRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteApplicationAuthenticationMethodRequestMarshaller(this.protocolFactory)));
            return deleteApplicationAuthenticationMethodResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteApplicationGrantResponse deleteApplicationGrant(DeleteApplicationGrantRequest deleteApplicationGrantRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteApplicationGrantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteApplicationGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, deleteApplicationGrantRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApplicationGrant");
            DeleteApplicationGrantResponse deleteApplicationGrantResponse = (DeleteApplicationGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteApplicationGrant").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteApplicationGrantRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteApplicationGrantRequestMarshaller(this.protocolFactory)));
            return deleteApplicationGrantResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInlinePolicyFromPermissionSetResponse deleteInlinePolicyFromPermissionSet(DeleteInlinePolicyFromPermissionSetRequest deleteInlinePolicyFromPermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInlinePolicyFromPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteInlinePolicyFromPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, deleteInlinePolicyFromPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInlinePolicyFromPermissionSet");
            DeleteInlinePolicyFromPermissionSetResponse deleteInlinePolicyFromPermissionSetResponse = (DeleteInlinePolicyFromPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInlinePolicyFromPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteInlinePolicyFromPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteInlinePolicyFromPermissionSetRequestMarshaller(this.protocolFactory)));
            return deleteInlinePolicyFromPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInstanceResponse deleteInstance(DeleteInstanceRequest deleteInstanceRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, deleteInstanceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstance");
            DeleteInstanceResponse deleteInstanceResponse = (DeleteInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInstance").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteInstanceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteInstanceRequestMarshaller(this.protocolFactory)));
            return deleteInstanceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteInstanceAccessControlAttributeConfigurationResponse deleteInstanceAccessControlAttributeConfiguration(DeleteInstanceAccessControlAttributeConfigurationRequest deleteInstanceAccessControlAttributeConfigurationRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteInstanceAccessControlAttributeConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteInstanceAccessControlAttributeConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, deleteInstanceAccessControlAttributeConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceAccessControlAttributeConfiguration");
            DeleteInstanceAccessControlAttributeConfigurationResponse deleteInstanceAccessControlAttributeConfigurationResponse = (DeleteInstanceAccessControlAttributeConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInstanceAccessControlAttributeConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteInstanceAccessControlAttributeConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteInstanceAccessControlAttributeConfigurationRequestMarshaller(this.protocolFactory)));
            return deleteInstanceAccessControlAttributeConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePermissionSetResponse deletePermissionSet(DeletePermissionSetRequest deletePermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deletePermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, deletePermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePermissionSet");
            DeletePermissionSetResponse deletePermissionSetResponse = (DeletePermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deletePermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeletePermissionSetRequestMarshaller(this.protocolFactory)));
            return deletePermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeletePermissionsBoundaryFromPermissionSetResponse deletePermissionsBoundaryFromPermissionSet(DeletePermissionsBoundaryFromPermissionSetRequest deletePermissionsBoundaryFromPermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeletePermissionsBoundaryFromPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deletePermissionsBoundaryFromPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, deletePermissionsBoundaryFromPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePermissionsBoundaryFromPermissionSet");
            DeletePermissionsBoundaryFromPermissionSetResponse deletePermissionsBoundaryFromPermissionSetResponse = (DeletePermissionsBoundaryFromPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeletePermissionsBoundaryFromPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deletePermissionsBoundaryFromPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeletePermissionsBoundaryFromPermissionSetRequestMarshaller(this.protocolFactory)));
            return deletePermissionsBoundaryFromPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrustedTokenIssuerResponse deleteTrustedTokenIssuer(DeleteTrustedTokenIssuerRequest deleteTrustedTokenIssuerRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTrustedTokenIssuerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(deleteTrustedTokenIssuerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, deleteTrustedTokenIssuerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTrustedTokenIssuer");
            DeleteTrustedTokenIssuerResponse deleteTrustedTokenIssuerResponse = (DeleteTrustedTokenIssuerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrustedTokenIssuer").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(deleteTrustedTokenIssuerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteTrustedTokenIssuerRequestMarshaller(this.protocolFactory)));
            return deleteTrustedTokenIssuerResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountAssignmentCreationStatusResponse describeAccountAssignmentCreationStatus(DescribeAccountAssignmentCreationStatusRequest describeAccountAssignmentCreationStatusRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountAssignmentCreationStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeAccountAssignmentCreationStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, describeAccountAssignmentCreationStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAssignmentCreationStatus");
            DescribeAccountAssignmentCreationStatusResponse describeAccountAssignmentCreationStatusResponse = (DescribeAccountAssignmentCreationStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountAssignmentCreationStatus").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(describeAccountAssignmentCreationStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeAccountAssignmentCreationStatusRequestMarshaller(this.protocolFactory)));
            return describeAccountAssignmentCreationStatusResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAccountAssignmentDeletionStatusResponse describeAccountAssignmentDeletionStatus(DescribeAccountAssignmentDeletionStatusRequest describeAccountAssignmentDeletionStatusRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeAccountAssignmentDeletionStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeAccountAssignmentDeletionStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, describeAccountAssignmentDeletionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountAssignmentDeletionStatus");
            DescribeAccountAssignmentDeletionStatusResponse describeAccountAssignmentDeletionStatusResponse = (DescribeAccountAssignmentDeletionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAccountAssignmentDeletionStatus").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(describeAccountAssignmentDeletionStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeAccountAssignmentDeletionStatusRequestMarshaller(this.protocolFactory)));
            return describeAccountAssignmentDeletionStatusResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationResponse describeApplication(DescribeApplicationRequest describeApplicationRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, describeApplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApplication");
            DescribeApplicationResponse describeApplicationResponse = (DescribeApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplication").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(describeApplicationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeApplicationRequestMarshaller(this.protocolFactory)));
            return describeApplicationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationAssignmentResponse describeApplicationAssignment(DescribeApplicationAssignmentRequest describeApplicationAssignmentRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationAssignmentResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeApplicationAssignmentRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, describeApplicationAssignmentRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApplicationAssignment");
            DescribeApplicationAssignmentResponse describeApplicationAssignmentResponse = (DescribeApplicationAssignmentResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationAssignment").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(describeApplicationAssignmentRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeApplicationAssignmentRequestMarshaller(this.protocolFactory)));
            return describeApplicationAssignmentResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeApplicationProviderResponse describeApplicationProvider(DescribeApplicationProviderRequest describeApplicationProviderRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeApplicationProviderResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeApplicationProviderRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, describeApplicationProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeApplicationProvider");
            DescribeApplicationProviderResponse describeApplicationProviderResponse = (DescribeApplicationProviderResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeApplicationProvider").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(describeApplicationProviderRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeApplicationProviderRequestMarshaller(this.protocolFactory)));
            return describeApplicationProviderResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInstanceResponse describeInstance(DescribeInstanceRequest describeInstanceRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, describeInstanceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstance");
            DescribeInstanceResponse describeInstanceResponse = (DescribeInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInstance").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(describeInstanceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeInstanceRequestMarshaller(this.protocolFactory)));
            return describeInstanceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeInstanceAccessControlAttributeConfigurationResponse describeInstanceAccessControlAttributeConfiguration(DescribeInstanceAccessControlAttributeConfigurationRequest describeInstanceAccessControlAttributeConfigurationRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeInstanceAccessControlAttributeConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeInstanceAccessControlAttributeConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, describeInstanceAccessControlAttributeConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstanceAccessControlAttributeConfiguration");
            DescribeInstanceAccessControlAttributeConfigurationResponse describeInstanceAccessControlAttributeConfigurationResponse = (DescribeInstanceAccessControlAttributeConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInstanceAccessControlAttributeConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(describeInstanceAccessControlAttributeConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeInstanceAccessControlAttributeConfigurationRequestMarshaller(this.protocolFactory)));
            return describeInstanceAccessControlAttributeConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePermissionSetResponse describePermissionSet(DescribePermissionSetRequest describePermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describePermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, describePermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePermissionSet");
            DescribePermissionSetResponse describePermissionSetResponse = (DescribePermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(describePermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribePermissionSetRequestMarshaller(this.protocolFactory)));
            return describePermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribePermissionSetProvisioningStatusResponse describePermissionSetProvisioningStatus(DescribePermissionSetProvisioningStatusRequest describePermissionSetProvisioningStatusRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribePermissionSetProvisioningStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describePermissionSetProvisioningStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, describePermissionSetProvisioningStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePermissionSetProvisioningStatus");
            DescribePermissionSetProvisioningStatusResponse describePermissionSetProvisioningStatusResponse = (DescribePermissionSetProvisioningStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribePermissionSetProvisioningStatus").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(describePermissionSetProvisioningStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribePermissionSetProvisioningStatusRequestMarshaller(this.protocolFactory)));
            return describePermissionSetProvisioningStatusResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrustedTokenIssuerResponse describeTrustedTokenIssuer(DescribeTrustedTokenIssuerRequest describeTrustedTokenIssuerRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrustedTokenIssuerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(describeTrustedTokenIssuerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, describeTrustedTokenIssuerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTrustedTokenIssuer");
            DescribeTrustedTokenIssuerResponse describeTrustedTokenIssuerResponse = (DescribeTrustedTokenIssuerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrustedTokenIssuer").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(describeTrustedTokenIssuerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DescribeTrustedTokenIssuerRequestMarshaller(this.protocolFactory)));
            return describeTrustedTokenIssuerResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachCustomerManagedPolicyReferenceFromPermissionSetResponse detachCustomerManagedPolicyReferenceFromPermissionSet(DetachCustomerManagedPolicyReferenceFromPermissionSetRequest detachCustomerManagedPolicyReferenceFromPermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachCustomerManagedPolicyReferenceFromPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(detachCustomerManagedPolicyReferenceFromPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, detachCustomerManagedPolicyReferenceFromPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachCustomerManagedPolicyReferenceFromPermissionSet");
            DetachCustomerManagedPolicyReferenceFromPermissionSetResponse detachCustomerManagedPolicyReferenceFromPermissionSetResponse = (DetachCustomerManagedPolicyReferenceFromPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachCustomerManagedPolicyReferenceFromPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(detachCustomerManagedPolicyReferenceFromPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DetachCustomerManagedPolicyReferenceFromPermissionSetRequestMarshaller(this.protocolFactory)));
            return detachCustomerManagedPolicyReferenceFromPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DetachManagedPolicyFromPermissionSetResponse detachManagedPolicyFromPermissionSet(DetachManagedPolicyFromPermissionSetRequest detachManagedPolicyFromPermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DetachManagedPolicyFromPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(detachManagedPolicyFromPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, detachManagedPolicyFromPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachManagedPolicyFromPermissionSet");
            DetachManagedPolicyFromPermissionSetResponse detachManagedPolicyFromPermissionSetResponse = (DetachManagedPolicyFromPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DetachManagedPolicyFromPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(detachManagedPolicyFromPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new DetachManagedPolicyFromPermissionSetRequestMarshaller(this.protocolFactory)));
            return detachManagedPolicyFromPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApplicationAccessScopeResponse getApplicationAccessScope(GetApplicationAccessScopeRequest getApplicationAccessScopeRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApplicationAccessScopeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getApplicationAccessScopeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, getApplicationAccessScopeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationAccessScope");
            GetApplicationAccessScopeResponse getApplicationAccessScopeResponse = (GetApplicationAccessScopeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApplicationAccessScope").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getApplicationAccessScopeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetApplicationAccessScopeRequestMarshaller(this.protocolFactory)));
            return getApplicationAccessScopeResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApplicationAssignmentConfigurationResponse getApplicationAssignmentConfiguration(GetApplicationAssignmentConfigurationRequest getApplicationAssignmentConfigurationRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApplicationAssignmentConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getApplicationAssignmentConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, getApplicationAssignmentConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationAssignmentConfiguration");
            GetApplicationAssignmentConfigurationResponse getApplicationAssignmentConfigurationResponse = (GetApplicationAssignmentConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApplicationAssignmentConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getApplicationAssignmentConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetApplicationAssignmentConfigurationRequestMarshaller(this.protocolFactory)));
            return getApplicationAssignmentConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApplicationAuthenticationMethodResponse getApplicationAuthenticationMethod(GetApplicationAuthenticationMethodRequest getApplicationAuthenticationMethodRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApplicationAuthenticationMethodResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getApplicationAuthenticationMethodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, getApplicationAuthenticationMethodRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationAuthenticationMethod");
            GetApplicationAuthenticationMethodResponse getApplicationAuthenticationMethodResponse = (GetApplicationAuthenticationMethodResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApplicationAuthenticationMethod").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getApplicationAuthenticationMethodRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetApplicationAuthenticationMethodRequestMarshaller(this.protocolFactory)));
            return getApplicationAuthenticationMethodResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApplicationGrantResponse getApplicationGrant(GetApplicationGrantRequest getApplicationGrantRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApplicationGrantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getApplicationGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, getApplicationGrantRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationGrant");
            GetApplicationGrantResponse getApplicationGrantResponse = (GetApplicationGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApplicationGrant").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getApplicationGrantRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetApplicationGrantRequestMarshaller(this.protocolFactory)));
            return getApplicationGrantResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetApplicationSessionConfigurationResponse getApplicationSessionConfiguration(GetApplicationSessionConfigurationRequest getApplicationSessionConfigurationRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApplicationSessionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getApplicationSessionConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, getApplicationSessionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApplicationSessionConfiguration");
            GetApplicationSessionConfigurationResponse getApplicationSessionConfigurationResponse = (GetApplicationSessionConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApplicationSessionConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getApplicationSessionConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetApplicationSessionConfigurationRequestMarshaller(this.protocolFactory)));
            return getApplicationSessionConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInlinePolicyForPermissionSetResponse getInlinePolicyForPermissionSet(GetInlinePolicyForPermissionSetRequest getInlinePolicyForPermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInlinePolicyForPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getInlinePolicyForPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, getInlinePolicyForPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInlinePolicyForPermissionSet");
            GetInlinePolicyForPermissionSetResponse getInlinePolicyForPermissionSetResponse = (GetInlinePolicyForPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInlinePolicyForPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getInlinePolicyForPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetInlinePolicyForPermissionSetRequestMarshaller(this.protocolFactory)));
            return getInlinePolicyForPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetPermissionsBoundaryForPermissionSetResponse getPermissionsBoundaryForPermissionSet(GetPermissionsBoundaryForPermissionSetRequest getPermissionsBoundaryForPermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetPermissionsBoundaryForPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(getPermissionsBoundaryForPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, getPermissionsBoundaryForPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPermissionsBoundaryForPermissionSet");
            GetPermissionsBoundaryForPermissionSetResponse getPermissionsBoundaryForPermissionSetResponse = (GetPermissionsBoundaryForPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetPermissionsBoundaryForPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(getPermissionsBoundaryForPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new GetPermissionsBoundaryForPermissionSetRequestMarshaller(this.protocolFactory)));
            return getPermissionsBoundaryForPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccountAssignmentCreationStatusResponse listAccountAssignmentCreationStatus(ListAccountAssignmentCreationStatusRequest listAccountAssignmentCreationStatusRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountAssignmentCreationStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listAccountAssignmentCreationStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listAccountAssignmentCreationStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAssignmentCreationStatus");
            ListAccountAssignmentCreationStatusResponse listAccountAssignmentCreationStatusResponse = (ListAccountAssignmentCreationStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccountAssignmentCreationStatus").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listAccountAssignmentCreationStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListAccountAssignmentCreationStatusRequestMarshaller(this.protocolFactory)));
            return listAccountAssignmentCreationStatusResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccountAssignmentDeletionStatusResponse listAccountAssignmentDeletionStatus(ListAccountAssignmentDeletionStatusRequest listAccountAssignmentDeletionStatusRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountAssignmentDeletionStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listAccountAssignmentDeletionStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listAccountAssignmentDeletionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAssignmentDeletionStatus");
            ListAccountAssignmentDeletionStatusResponse listAccountAssignmentDeletionStatusResponse = (ListAccountAssignmentDeletionStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccountAssignmentDeletionStatus").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listAccountAssignmentDeletionStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListAccountAssignmentDeletionStatusRequestMarshaller(this.protocolFactory)));
            return listAccountAssignmentDeletionStatusResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccountAssignmentsResponse listAccountAssignments(ListAccountAssignmentsRequest listAccountAssignmentsRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountAssignmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listAccountAssignmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listAccountAssignmentsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAssignments");
            ListAccountAssignmentsResponse listAccountAssignmentsResponse = (ListAccountAssignmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccountAssignments").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listAccountAssignmentsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListAccountAssignmentsRequestMarshaller(this.protocolFactory)));
            return listAccountAssignmentsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccountAssignmentsForPrincipalResponse listAccountAssignmentsForPrincipal(ListAccountAssignmentsForPrincipalRequest listAccountAssignmentsForPrincipalRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountAssignmentsForPrincipalResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listAccountAssignmentsForPrincipalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listAccountAssignmentsForPrincipalRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAssignmentsForPrincipal");
            ListAccountAssignmentsForPrincipalResponse listAccountAssignmentsForPrincipalResponse = (ListAccountAssignmentsForPrincipalResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccountAssignmentsForPrincipal").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listAccountAssignmentsForPrincipalRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListAccountAssignmentsForPrincipalRequestMarshaller(this.protocolFactory)));
            return listAccountAssignmentsForPrincipalResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAccountsForProvisionedPermissionSetResponse listAccountsForProvisionedPermissionSet(ListAccountsForProvisionedPermissionSetRequest listAccountsForProvisionedPermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAccountsForProvisionedPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listAccountsForProvisionedPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listAccountsForProvisionedPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountsForProvisionedPermissionSet");
            ListAccountsForProvisionedPermissionSetResponse listAccountsForProvisionedPermissionSetResponse = (ListAccountsForProvisionedPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAccountsForProvisionedPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listAccountsForProvisionedPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListAccountsForProvisionedPermissionSetRequestMarshaller(this.protocolFactory)));
            return listAccountsForProvisionedPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationAccessScopesResponse listApplicationAccessScopes(ListApplicationAccessScopesRequest listApplicationAccessScopesRequest) throws ThrottlingException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationAccessScopesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listApplicationAccessScopesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listApplicationAccessScopesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplicationAccessScopes");
            ListApplicationAccessScopesResponse listApplicationAccessScopesResponse = (ListApplicationAccessScopesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationAccessScopes").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listApplicationAccessScopesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListApplicationAccessScopesRequestMarshaller(this.protocolFactory)));
            return listApplicationAccessScopesResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationAssignmentsResponse listApplicationAssignments(ListApplicationAssignmentsRequest listApplicationAssignmentsRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationAssignmentsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listApplicationAssignmentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listApplicationAssignmentsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplicationAssignments");
            ListApplicationAssignmentsResponse listApplicationAssignmentsResponse = (ListApplicationAssignmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationAssignments").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listApplicationAssignmentsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListApplicationAssignmentsRequestMarshaller(this.protocolFactory)));
            return listApplicationAssignmentsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationAssignmentsForPrincipalResponse listApplicationAssignmentsForPrincipal(ListApplicationAssignmentsForPrincipalRequest listApplicationAssignmentsForPrincipalRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationAssignmentsForPrincipalResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listApplicationAssignmentsForPrincipalRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listApplicationAssignmentsForPrincipalRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplicationAssignmentsForPrincipal");
            ListApplicationAssignmentsForPrincipalResponse listApplicationAssignmentsForPrincipalResponse = (ListApplicationAssignmentsForPrincipalResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationAssignmentsForPrincipal").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listApplicationAssignmentsForPrincipalRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListApplicationAssignmentsForPrincipalRequestMarshaller(this.protocolFactory)));
            return listApplicationAssignmentsForPrincipalResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationAuthenticationMethodsResponse listApplicationAuthenticationMethods(ListApplicationAuthenticationMethodsRequest listApplicationAuthenticationMethodsRequest) throws ThrottlingException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationAuthenticationMethodsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listApplicationAuthenticationMethodsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listApplicationAuthenticationMethodsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplicationAuthenticationMethods");
            ListApplicationAuthenticationMethodsResponse listApplicationAuthenticationMethodsResponse = (ListApplicationAuthenticationMethodsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationAuthenticationMethods").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listApplicationAuthenticationMethodsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListApplicationAuthenticationMethodsRequestMarshaller(this.protocolFactory)));
            return listApplicationAuthenticationMethodsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationGrantsResponse listApplicationGrants(ListApplicationGrantsRequest listApplicationGrantsRequest) throws ThrottlingException, ResourceNotFoundException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationGrantsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listApplicationGrantsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listApplicationGrantsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplicationGrants");
            ListApplicationGrantsResponse listApplicationGrantsResponse = (ListApplicationGrantsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationGrants").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listApplicationGrantsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListApplicationGrantsRequestMarshaller(this.protocolFactory)));
            return listApplicationGrantsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationProvidersResponse listApplicationProviders(ListApplicationProvidersRequest listApplicationProvidersRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationProvidersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listApplicationProvidersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listApplicationProvidersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplicationProviders");
            ListApplicationProvidersResponse listApplicationProvidersResponse = (ListApplicationProvidersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplicationProviders").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listApplicationProvidersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListApplicationProvidersRequestMarshaller(this.protocolFactory)));
            return listApplicationProvidersResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListApplicationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listApplicationsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listApplicationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApplications");
            ListApplicationsResponse listApplicationsResponse = (ListApplicationsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListApplications").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listApplicationsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListApplicationsRequestMarshaller(this.protocolFactory)));
            return listApplicationsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListCustomerManagedPolicyReferencesInPermissionSetResponse listCustomerManagedPolicyReferencesInPermissionSet(ListCustomerManagedPolicyReferencesInPermissionSetRequest listCustomerManagedPolicyReferencesInPermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCustomerManagedPolicyReferencesInPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listCustomerManagedPolicyReferencesInPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listCustomerManagedPolicyReferencesInPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCustomerManagedPolicyReferencesInPermissionSet");
            ListCustomerManagedPolicyReferencesInPermissionSetResponse listCustomerManagedPolicyReferencesInPermissionSetResponse = (ListCustomerManagedPolicyReferencesInPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCustomerManagedPolicyReferencesInPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listCustomerManagedPolicyReferencesInPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListCustomerManagedPolicyReferencesInPermissionSetRequestMarshaller(this.protocolFactory)));
            return listCustomerManagedPolicyReferencesInPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInstancesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listInstancesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listInstancesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInstances");
            ListInstancesResponse listInstancesResponse = (ListInstancesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInstances").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listInstancesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListInstancesRequestMarshaller(this.protocolFactory)));
            return listInstancesResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListManagedPoliciesInPermissionSetResponse listManagedPoliciesInPermissionSet(ListManagedPoliciesInPermissionSetRequest listManagedPoliciesInPermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListManagedPoliciesInPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listManagedPoliciesInPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listManagedPoliciesInPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListManagedPoliciesInPermissionSet");
            ListManagedPoliciesInPermissionSetResponse listManagedPoliciesInPermissionSetResponse = (ListManagedPoliciesInPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListManagedPoliciesInPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listManagedPoliciesInPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListManagedPoliciesInPermissionSetRequestMarshaller(this.protocolFactory)));
            return listManagedPoliciesInPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPermissionSetProvisioningStatusResponse listPermissionSetProvisioningStatus(ListPermissionSetProvisioningStatusRequest listPermissionSetProvisioningStatusRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionSetProvisioningStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listPermissionSetProvisioningStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listPermissionSetProvisioningStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPermissionSetProvisioningStatus");
            ListPermissionSetProvisioningStatusResponse listPermissionSetProvisioningStatusResponse = (ListPermissionSetProvisioningStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissionSetProvisioningStatus").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listPermissionSetProvisioningStatusRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListPermissionSetProvisioningStatusRequestMarshaller(this.protocolFactory)));
            return listPermissionSetProvisioningStatusResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPermissionSetsResponse listPermissionSets(ListPermissionSetsRequest listPermissionSetsRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionSetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listPermissionSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listPermissionSetsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPermissionSets");
            ListPermissionSetsResponse listPermissionSetsResponse = (ListPermissionSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissionSets").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listPermissionSetsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListPermissionSetsRequestMarshaller(this.protocolFactory)));
            return listPermissionSetsResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPermissionSetsProvisionedToAccountResponse listPermissionSetsProvisionedToAccount(ListPermissionSetsProvisionedToAccountRequest listPermissionSetsProvisionedToAccountRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPermissionSetsProvisionedToAccountResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listPermissionSetsProvisionedToAccountRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listPermissionSetsProvisionedToAccountRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPermissionSetsProvisionedToAccount");
            ListPermissionSetsProvisionedToAccountResponse listPermissionSetsProvisionedToAccountResponse = (ListPermissionSetsProvisionedToAccountResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListPermissionSetsProvisionedToAccount").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listPermissionSetsProvisionedToAccountRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListPermissionSetsProvisionedToAccountRequestMarshaller(this.protocolFactory)));
            return listPermissionSetsProvisionedToAccountResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListTagsForResourceRequestMarshaller(this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTrustedTokenIssuersResponse listTrustedTokenIssuers(ListTrustedTokenIssuersRequest listTrustedTokenIssuersRequest) throws ThrottlingException, InternalServerException, AccessDeniedException, ValidationException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTrustedTokenIssuersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(listTrustedTokenIssuersRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, listTrustedTokenIssuersRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTrustedTokenIssuers");
            ListTrustedTokenIssuersResponse listTrustedTokenIssuersResponse = (ListTrustedTokenIssuersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrustedTokenIssuers").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(listTrustedTokenIssuersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ListTrustedTokenIssuersRequestMarshaller(this.protocolFactory)));
            return listTrustedTokenIssuersResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProvisionPermissionSetResponse provisionPermissionSet(ProvisionPermissionSetRequest provisionPermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ProvisionPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(provisionPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, provisionPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ProvisionPermissionSet");
            ProvisionPermissionSetResponse provisionPermissionSetResponse = (ProvisionPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ProvisionPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(provisionPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new ProvisionPermissionSetRequestMarshaller(this.protocolFactory)));
            return provisionPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutApplicationAccessScopeResponse putApplicationAccessScope(PutApplicationAccessScopeRequest putApplicationAccessScopeRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutApplicationAccessScopeResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putApplicationAccessScopeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, putApplicationAccessScopeRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutApplicationAccessScope");
            PutApplicationAccessScopeResponse putApplicationAccessScopeResponse = (PutApplicationAccessScopeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutApplicationAccessScope").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(putApplicationAccessScopeRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new PutApplicationAccessScopeRequestMarshaller(this.protocolFactory)));
            return putApplicationAccessScopeResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutApplicationAssignmentConfigurationResponse putApplicationAssignmentConfiguration(PutApplicationAssignmentConfigurationRequest putApplicationAssignmentConfigurationRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutApplicationAssignmentConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putApplicationAssignmentConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, putApplicationAssignmentConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutApplicationAssignmentConfiguration");
            PutApplicationAssignmentConfigurationResponse putApplicationAssignmentConfigurationResponse = (PutApplicationAssignmentConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutApplicationAssignmentConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(putApplicationAssignmentConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new PutApplicationAssignmentConfigurationRequestMarshaller(this.protocolFactory)));
            return putApplicationAssignmentConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutApplicationAuthenticationMethodResponse putApplicationAuthenticationMethod(PutApplicationAuthenticationMethodRequest putApplicationAuthenticationMethodRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutApplicationAuthenticationMethodResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putApplicationAuthenticationMethodRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, putApplicationAuthenticationMethodRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutApplicationAuthenticationMethod");
            PutApplicationAuthenticationMethodResponse putApplicationAuthenticationMethodResponse = (PutApplicationAuthenticationMethodResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutApplicationAuthenticationMethod").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(putApplicationAuthenticationMethodRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new PutApplicationAuthenticationMethodRequestMarshaller(this.protocolFactory)));
            return putApplicationAuthenticationMethodResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutApplicationGrantResponse putApplicationGrant(PutApplicationGrantRequest putApplicationGrantRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutApplicationGrantResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putApplicationGrantRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, putApplicationGrantRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutApplicationGrant");
            PutApplicationGrantResponse putApplicationGrantResponse = (PutApplicationGrantResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutApplicationGrant").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(putApplicationGrantRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new PutApplicationGrantRequestMarshaller(this.protocolFactory)));
            return putApplicationGrantResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutApplicationSessionConfigurationResponse putApplicationSessionConfiguration(PutApplicationSessionConfigurationRequest putApplicationSessionConfigurationRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutApplicationSessionConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putApplicationSessionConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, putApplicationSessionConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutApplicationSessionConfiguration");
            PutApplicationSessionConfigurationResponse putApplicationSessionConfigurationResponse = (PutApplicationSessionConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutApplicationSessionConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(putApplicationSessionConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new PutApplicationSessionConfigurationRequestMarshaller(this.protocolFactory)));
            return putApplicationSessionConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutInlinePolicyToPermissionSetResponse putInlinePolicyToPermissionSet(PutInlinePolicyToPermissionSetRequest putInlinePolicyToPermissionSetRequest) throws ServiceQuotaExceededException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutInlinePolicyToPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putInlinePolicyToPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, putInlinePolicyToPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutInlinePolicyToPermissionSet");
            PutInlinePolicyToPermissionSetResponse putInlinePolicyToPermissionSetResponse = (PutInlinePolicyToPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutInlinePolicyToPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(putInlinePolicyToPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new PutInlinePolicyToPermissionSetRequestMarshaller(this.protocolFactory)));
            return putInlinePolicyToPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutPermissionsBoundaryToPermissionSetResponse putPermissionsBoundaryToPermissionSet(PutPermissionsBoundaryToPermissionSetRequest putPermissionsBoundaryToPermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutPermissionsBoundaryToPermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(putPermissionsBoundaryToPermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, putPermissionsBoundaryToPermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutPermissionsBoundaryToPermissionSet");
            PutPermissionsBoundaryToPermissionSetResponse putPermissionsBoundaryToPermissionSetResponse = (PutPermissionsBoundaryToPermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutPermissionsBoundaryToPermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(putPermissionsBoundaryToPermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new PutPermissionsBoundaryToPermissionSetRequestMarshaller(this.protocolFactory)));
            return putPermissionsBoundaryToPermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException, ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new TagResourceRequestMarshaller(this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UntagResourceRequestMarshaller(this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateApplicationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateApplicationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, updateApplicationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApplication");
            UpdateApplicationResponse updateApplicationResponse = (UpdateApplicationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateApplication").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateApplicationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateApplicationRequestMarshaller(this.protocolFactory)));
            return updateApplicationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateInstanceResponse updateInstance(UpdateInstanceRequest updateInstanceRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateInstanceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateInstanceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, updateInstanceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInstance");
            UpdateInstanceResponse updateInstanceResponse = (UpdateInstanceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateInstance").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateInstanceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateInstanceRequestMarshaller(this.protocolFactory)));
            return updateInstanceResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateInstanceAccessControlAttributeConfigurationResponse updateInstanceAccessControlAttributeConfiguration(UpdateInstanceAccessControlAttributeConfigurationRequest updateInstanceAccessControlAttributeConfigurationRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateInstanceAccessControlAttributeConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateInstanceAccessControlAttributeConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, updateInstanceAccessControlAttributeConfigurationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateInstanceAccessControlAttributeConfiguration");
            UpdateInstanceAccessControlAttributeConfigurationResponse updateInstanceAccessControlAttributeConfigurationResponse = (UpdateInstanceAccessControlAttributeConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateInstanceAccessControlAttributeConfiguration").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateInstanceAccessControlAttributeConfigurationRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateInstanceAccessControlAttributeConfigurationRequestMarshaller(this.protocolFactory)));
            return updateInstanceAccessControlAttributeConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdatePermissionSetResponse updatePermissionSet(UpdatePermissionSetRequest updatePermissionSetRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdatePermissionSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updatePermissionSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, updatePermissionSetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePermissionSet");
            UpdatePermissionSetResponse updatePermissionSetResponse = (UpdatePermissionSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdatePermissionSet").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updatePermissionSetRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdatePermissionSetRequestMarshaller(this.protocolFactory)));
            return updatePermissionSetResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateTrustedTokenIssuerResponse updateTrustedTokenIssuer(UpdateTrustedTokenIssuerRequest updateTrustedTokenIssuerRequest) throws ThrottlingException, InternalServerException, ResourceNotFoundException, AccessDeniedException, ValidationException, ConflictException, AwsServiceException, SdkClientException, SsoAdminException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateTrustedTokenIssuerResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InternalServerException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500).exceptionBuilderSupplier(InternalServerException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "ValidationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400).exceptionBuilderSupplier(ValidationException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400).exceptionBuilderSupplier(ConflictException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration(updateTrustedTokenIssuerRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultSsoAdminClient.resolveMetricPublishers(clientConfiguration, updateTrustedTokenIssuerRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSO Admin");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTrustedTokenIssuer");
            UpdateTrustedTokenIssuerResponse updateTrustedTokenIssuerResponse = (UpdateTrustedTokenIssuerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateTrustedTokenIssuer").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput(updateTrustedTokenIssuerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller(new UpdateTrustedTokenIssuerRequestMarshaller(this.protocolFactory)));
            return updateTrustedTokenIssuerResponse;
        }
        finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return "sso";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        SsoAdminServiceClientConfigurationBuilder serviceConfigBuilder = new SsoAdminServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return ((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)((BaseAwsJsonProtocolFactory.Builder)builder.clientConfiguration(this.clientConfiguration)).defaultServiceExceptionSupplier(SsoAdminException::builder)).protocol(AwsJsonProtocol.AWS_JSON)).protocolVersion("1.1");
    }

    @Override
    public final SsoAdminServiceClientConfiguration serviceClientConfiguration() {
        return new SsoAdminServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        this.clientHandler.close();
    }
}

