/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.services.ssoadmin.model.PrincipalType;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminRequest;
import software.amazon.awssdk.services.ssoadmin.model.TargetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAccountAssignmentRequest
extends SsoAdminRequest
implements ToCopyableBuilder<Builder, DeleteAccountAssignmentRequest> {
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("InstanceArn").getter(DeleteAccountAssignmentRequest.getter(DeleteAccountAssignmentRequest::instanceArn)).setter(DeleteAccountAssignmentRequest.setter(Builder::instanceArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceArn").build()).build();
    private static final SdkField<String> TARGET_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("TargetId").getter(DeleteAccountAssignmentRequest.getter(DeleteAccountAssignmentRequest::targetId)).setter(DeleteAccountAssignmentRequest.setter(Builder::targetId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetId").build()).build();
    private static final SdkField<String> TARGET_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("TargetType").getter(DeleteAccountAssignmentRequest.getter(DeleteAccountAssignmentRequest::targetTypeAsString)).setter(DeleteAccountAssignmentRequest.setter(Builder::targetType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetType").build()).build();
    private static final SdkField<String> PERMISSION_SET_ARN_FIELD = SdkField.builder(MarshallingType.STRING).memberName("PermissionSetArn").getter(DeleteAccountAssignmentRequest.getter(DeleteAccountAssignmentRequest::permissionSetArn)).setter(DeleteAccountAssignmentRequest.setter(Builder::permissionSetArn)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionSetArn").build()).build();
    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.builder(MarshallingType.STRING).memberName("PrincipalType").getter(DeleteAccountAssignmentRequest.getter(DeleteAccountAssignmentRequest::principalTypeAsString)).setter(DeleteAccountAssignmentRequest.setter(Builder::principalType)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalType").build()).build();
    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("PrincipalId").getter(DeleteAccountAssignmentRequest.getter(DeleteAccountAssignmentRequest::principalId)).setter(DeleteAccountAssignmentRequest.setter(Builder::principalId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrincipalId").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ARN_FIELD, TARGET_ID_FIELD, TARGET_TYPE_FIELD, PERMISSION_SET_ARN_FIELD, PRINCIPAL_TYPE_FIELD, PRINCIPAL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteAccountAssignmentRequest.memberNameToFieldInitializer();
    private final String instanceArn;
    private final String targetId;
    private final String targetType;
    private final String permissionSetArn;
    private final String principalType;
    private final String principalId;

    private DeleteAccountAssignmentRequest(BuilderImpl builder) {
        super(builder);
        this.instanceArn = builder.instanceArn;
        this.targetId = builder.targetId;
        this.targetType = builder.targetType;
        this.permissionSetArn = builder.permissionSetArn;
        this.principalType = builder.principalType;
        this.principalId = builder.principalId;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final String targetId() {
        return this.targetId;
    }

    public final TargetType targetType() {
        return TargetType.fromValue(this.targetType);
    }

    public final String targetTypeAsString() {
        return this.targetType;
    }

    public final String permissionSetArn() {
        return this.permissionSetArn;
    }

    public final PrincipalType principalType() {
        return PrincipalType.fromValue(this.principalType);
    }

    public final String principalTypeAsString() {
        return this.principalType;
    }

    public final String principalId() {
        return this.principalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAccountAssignmentRequest)) {
            return false;
        }
        DeleteAccountAssignmentRequest other = (DeleteAccountAssignmentRequest)obj;
        return Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.targetId(), other.targetId()) && Objects.equals(this.targetTypeAsString(), other.targetTypeAsString()) && Objects.equals(this.permissionSetArn(), other.permissionSetArn()) && Objects.equals(this.principalTypeAsString(), other.principalTypeAsString()) && Objects.equals(this.principalId(), other.principalId());
    }

    public final String toString() {
        return ToString.builder("DeleteAccountAssignmentRequest").add("InstanceArn", this.instanceArn()).add("TargetId", this.targetId()).add("TargetType", this.targetTypeAsString()).add("PermissionSetArn", this.permissionSetArn()).add("PrincipalType", this.principalTypeAsString()).add("PrincipalId", this.principalId()).build();
    }

    @Override
    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "TargetId": {
                return Optional.ofNullable(clazz.cast(this.targetId()));
            }
            case "TargetType": {
                return Optional.ofNullable(clazz.cast(this.targetTypeAsString()));
            }
            case "PermissionSetArn": {
                return Optional.ofNullable(clazz.cast(this.permissionSetArn()));
            }
            case "PrincipalType": {
                return Optional.ofNullable(clazz.cast(this.principalTypeAsString()));
            }
            case "PrincipalId": {
                return Optional.ofNullable(clazz.cast(this.principalId()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InstanceArn", INSTANCE_ARN_FIELD);
        map.put("TargetId", TARGET_ID_FIELD);
        map.put("TargetType", TARGET_TYPE_FIELD);
        map.put("PermissionSetArn", PERMISSION_SET_ARN_FIELD);
        map.put("PrincipalType", PRINCIPAL_TYPE_FIELD);
        map.put("PrincipalId", PRINCIPAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAccountAssignmentRequest, T> g) {
        return obj -> g.apply((DeleteAccountAssignmentRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminRequest.BuilderImpl
    implements Builder {
        private String instanceArn;
        private String targetId;
        private String targetType;
        private String permissionSetArn;
        private String principalType;
        private String principalId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAccountAssignmentRequest model) {
            super(model);
            this.instanceArn(model.instanceArn);
            this.targetId(model.targetId);
            this.targetType(model.targetType);
            this.permissionSetArn(model.permissionSetArn);
            this.principalType(model.principalType);
            this.principalId(model.principalId);
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getTargetId() {
            return this.targetId;
        }

        public final void setTargetId(String targetId) {
            this.targetId = targetId;
        }

        @Override
        public final Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public final String getTargetType() {
            return this.targetType;
        }

        public final void setTargetType(String targetType) {
            this.targetType = targetType;
        }

        @Override
        public final Builder targetType(String targetType) {
            this.targetType = targetType;
            return this;
        }

        @Override
        public final Builder targetType(TargetType targetType) {
            this.targetType(targetType == null ? null : targetType.toString());
            return this;
        }

        public final String getPermissionSetArn() {
            return this.permissionSetArn;
        }

        public final void setPermissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
        }

        @Override
        public final Builder permissionSetArn(String permissionSetArn) {
            this.permissionSetArn = permissionSetArn;
            return this;
        }

        public final String getPrincipalType() {
            return this.principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final String getPrincipalId() {
            return this.principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAccountAssignmentRequest build() {
            return new DeleteAccountAssignmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SsoAdminRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAccountAssignmentRequest> {
        public Builder instanceArn(String var1);

        public Builder targetId(String var1);

        public Builder targetType(String var1);

        public Builder targetType(TargetType var1);

        public Builder permissionSetArn(String var1);

        public Builder principalType(String var1);

        public Builder principalType(PrincipalType var1);

        public Builder principalId(String var1);

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

