/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAccessScopesResponse;
import software.amazon.awssdk.services.ssoadmin.model.ScopeDetails;

public class ListApplicationAccessScopesIterable
implements SdkIterable<ListApplicationAccessScopesResponse> {
    private final SsoAdminClient client;
    private final ListApplicationAccessScopesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApplicationAccessScopesIterable(SsoAdminClient client, ListApplicationAccessScopesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApplicationAccessScopesResponseFetcher();
    }

    @Override
    public Iterator<ListApplicationAccessScopesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScopeDetails> scopes() {
        Function<ListApplicationAccessScopesResponse, Iterator> getIterator = response -> {
            if (response != null && response.scopes() != null) {
                return response.scopes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable(this).itemIteratorFunction(getIterator).build();
    }

    private class ListApplicationAccessScopesResponseFetcher
    implements SyncPageFetcher<ListApplicationAccessScopesResponse> {
        private ListApplicationAccessScopesResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListApplicationAccessScopesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListApplicationAccessScopesResponse nextPage(ListApplicationAccessScopesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationAccessScopesIterable.this.client.listApplicationAccessScopes(ListApplicationAccessScopesIterable.this.firstRequest);
            }
            return ListApplicationAccessScopesIterable.this.client.listApplicationAccessScopes((ListApplicationAccessScopesRequest)ListApplicationAccessScopesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

