/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssoadmin.SsoAdminAsyncClient;
import software.amazon.awssdk.services.ssoadmin.internal.UserAgentUtils;
import software.amazon.awssdk.services.ssoadmin.model.AuthenticationMethodItem;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsRequest;
import software.amazon.awssdk.services.ssoadmin.model.ListApplicationAuthenticationMethodsResponse;

public class ListApplicationAuthenticationMethodsPublisher
implements SdkPublisher<ListApplicationAuthenticationMethodsResponse> {
    private final SsoAdminAsyncClient client;
    private final ListApplicationAuthenticationMethodsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationAuthenticationMethodsPublisher(SsoAdminAsyncClient client, ListApplicationAuthenticationMethodsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationAuthenticationMethodsPublisher(SsoAdminAsyncClient client, ListApplicationAuthenticationMethodsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationAuthenticationMethodsResponseFetcher();
    }

    @Override
    public void subscribe(Subscriber<? super ListApplicationAuthenticationMethodsResponse> subscriber) {
        subscriber.onSubscribe(((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AuthenticationMethodItem> authenticationMethods() {
        Function<ListApplicationAuthenticationMethodsResponse, Iterator> getIterator = response -> {
            if (response != null && response.authenticationMethods() != null) {
                return response.authenticationMethods().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher(new ListApplicationAuthenticationMethodsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationAuthenticationMethodsResponseFetcher
    implements AsyncPageFetcher<ListApplicationAuthenticationMethodsResponse> {
        private ListApplicationAuthenticationMethodsResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListApplicationAuthenticationMethodsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public CompletableFuture<ListApplicationAuthenticationMethodsResponse> nextPage(ListApplicationAuthenticationMethodsResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationAuthenticationMethodsPublisher.this.client.listApplicationAuthenticationMethods(ListApplicationAuthenticationMethodsPublisher.this.firstRequest);
            }
            return ListApplicationAuthenticationMethodsPublisher.this.client.listApplicationAuthenticationMethods((ListApplicationAuthenticationMethodsRequest)ListApplicationAuthenticationMethodsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

