/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sts.auth;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.core.useragent.BusinessMetricFeatureId;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsCredentialsProvider;
import software.amazon.awssdk.services.sts.internal.StsAuthUtils;
import software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import software.amazon.awssdk.services.sts.model.GetSessionTokenResponse;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkPublicApi
@ThreadSafe
public class StsGetSessionTokenCredentialsProvider
extends StsCredentialsProvider
implements ToCopyableBuilder<Builder, StsGetSessionTokenCredentialsProvider> {
    private static final String PROVIDER_NAME = BusinessMetricFeatureId.CREDENTIALS_STS_SESSION_TOKEN.value();
    private final GetSessionTokenRequest getSessionTokenRequest;
    private final String sourceChain;
    private final String providerName;

    private StsGetSessionTokenCredentialsProvider(Builder builder) {
        super(builder, "sts-get-token-credentials-provider");
        Validate.notNull(builder.getSessionTokenRequest, "Get session token request must not be null.", new Object[0]);
        this.getSessionTokenRequest = builder.getSessionTokenRequest;
        this.sourceChain = builder.sourceChain;
        this.providerName = StringUtils.isEmpty(builder.sourceChain) ? PROVIDER_NAME : builder.sourceChain + "," + PROVIDER_NAME;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    protected AwsSessionCredentials getUpdatedCredentials(StsClient stsClient) {
        GetSessionTokenResponse sessionToken = stsClient.getSessionToken(this.getSessionTokenRequest);
        return StsAuthUtils.fromStsCredentials(sessionToken.credentials(), this.providerName());
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    String providerName() {
        return this.providerName;
    }

    @NotThreadSafe
    public static final class Builder
    extends StsCredentialsProvider.BaseBuilder<Builder, StsGetSessionTokenCredentialsProvider> {
        private GetSessionTokenRequest getSessionTokenRequest = (GetSessionTokenRequest)GetSessionTokenRequest.builder().build();
        private String sourceChain;

        private Builder() {
            super((B x$0) -> new StsGetSessionTokenCredentialsProvider((Builder)x$0));
        }

        public Builder(StsGetSessionTokenCredentialsProvider provider) {
            super(x$0 -> new StsGetSessionTokenCredentialsProvider((Builder)x$0), provider);
            this.getSessionTokenRequest = provider.getSessionTokenRequest;
            this.sourceChain = provider.sourceChain;
        }

        public Builder refreshRequest(GetSessionTokenRequest getSessionTokenRequest) {
            this.getSessionTokenRequest = getSessionTokenRequest;
            return this;
        }

        public Builder refreshRequest(Consumer<GetSessionTokenRequest.Builder> getFederationTokenRequest) {
            return this.refreshRequest((GetSessionTokenRequest)GetSessionTokenRequest.builder().applyMutation(getFederationTokenRequest).build());
        }

        public Builder sourceChain(String sourceChain) {
            this.sourceChain = sourceChain;
            return this;
        }

        @Override
        public StsGetSessionTokenCredentialsProvider build() {
            return (StsGetSessionTokenCredentialsProvider)super.build();
        }
    }
}

